/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.mapper;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class BrowseItemForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = BrowseItemForm.message("xmlui.general.dspace_home");
    private static final Message T_submit_return = BrowseItemForm.message("xmlui.general.return");
    private static final Message T_mapper_trail = BrowseItemForm.message("xmlui.administrative.mapper.general.mapper_trail");
    private static final Message T_title = BrowseItemForm.message("xmlui.administrative.mapper.BrowseItemForm.title");
    private static final Message T_trail = BrowseItemForm.message("xmlui.administrative.mapper.BrowseItemForm.trail");
    private static final Message T_head1 = BrowseItemForm.message("xmlui.administrative.mapper.BrowseItemForm.head1");
    private static final Message T_submit_unmap = BrowseItemForm.message("xmlui.administrative.mapper.BrowseItemForm.submit_unmap");
    private static final Message T_column1 = BrowseItemForm.message("xmlui.administrative.mapper.BrowseItemForm.column1");
    private static final Message T_column2 = BrowseItemForm.message("xmlui.administrative.mapper.BrowseItemForm.column2");
    private static final Message T_column3 = BrowseItemForm.message("xmlui.administrative.mapper.BrowseItemForm.column3");
    private static final Message T_column4 = BrowseItemForm.message("xmlui.administrative.mapper.BrowseItemForm.column4");
    private static final Message T_no_remove = BrowseItemForm.message("xmlui.administrative.mapper.BrowseItemForm.no_remove");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_mapper_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, SQLException {
        Para actions;
        Para actions2;
        int collectionID = this.parameters.getParameterAsInteger("collectionID", -1);
        Collection collection = Collection.find((Context)this.context, (int)collectionID);
        List<Item> items = this.getMappedItems(collection);
        Division div = body.addInteractiveDivision("browse-items", this.contextPath + "/admin/mapper", "get", "primary administrative mapper");
        div.setHead(T_head1);
        if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)collection, (int)4)) {
            actions2 = div.addPara();
            actions2.addButton("submit_unmap").setValue(T_submit_unmap);
            actions2.addButton("submit_return").setValue(T_submit_return);
        } else {
            actions2 = div.addPara();
            Button button = actions2.addButton("submit_unmap");
            button.setValue(T_submit_unmap);
            button.setDisabled();
            actions2.addButton("submit_return").setValue(T_submit_return);
            div.addPara().addHighlight("fade").addContent(T_no_remove);
        }
        Table table = div.addTable("browse-items-table", 1, 1);
        Row header = table.addRow("header");
        header.addCellContent(T_column1);
        header.addCellContent(T_column2);
        header.addCellContent(T_column3);
        header.addCellContent(T_column4);
        for (Item item : items) {
            String itemID = String.valueOf(item.getID());
            Collection owningCollection = item.getOwningCollection();
            String owning = owningCollection.getMetadata("name");
            String author = "unknown";
            DCValue[] dcAuthors = item.getDC("contributor", "*", "*");
            if (dcAuthors != null && dcAuthors.length >= 1) {
                author = dcAuthors[0].value;
            }
            String title = "untitled";
            DCValue[] dcTitles = item.getDC("title", null, "*");
            if (dcTitles != null && dcTitles.length >= 1) {
                title = dcTitles[0].value;
            }
            String url = this.contextPath + "/handle/" + item.getHandle();
            Row row = table.addRow();
            CheckBox select = row.addCell().addCheckBox("itemID");
            select.setLabel("Select");
            select.addOption(itemID);
            row.addCellContent(owning);
            row.addCell().addXref(url, author);
            row.addCell().addXref(url, title);
        }
        if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)collection, (int)4)) {
            actions = div.addPara();
            actions.addButton("submit_unmap").setValue(T_submit_unmap);
            actions.addButton("submit_return").setValue(T_submit_return);
        } else {
            actions = div.addPara();
            Button button = actions.addButton("submit_unmap");
            button.setValue(T_submit_unmap);
            button.setDisabled();
            actions.addButton("submit_return").setValue(T_submit_return);
            div.addPara().addHighlight("fade").addContent(T_no_remove);
        }
        div.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Item> getMappedItems(Collection collection) throws SQLException {
        ArrayList<Item> items = new ArrayList<Item>();
        ItemIterator iterator = collection.getItems();
        try {
            while (iterator.hasNext()) {
                Item item = iterator.next();
                if (item.isOwningCollection(collection)) continue;
                items.add(item);
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return items;
    }
}

