/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.registries;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.core.Context;

public class DeleteMetadataFieldsConfirm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = DeleteMetadataFieldsConfirm.message("xmlui.general.dspace_home");
    private static final Message T_submit_delete = DeleteMetadataFieldsConfirm.message("xmlui.general.delete");
    private static final Message T_submit_cancel = DeleteMetadataFieldsConfirm.message("xmlui.general.cancel");
    private static final Message T_title = DeleteMetadataFieldsConfirm.message("xmlui.administrative.registries.DeleteMetadataFieldsConfirm.title");
    private static final Message T_metadata_registry_trail = DeleteMetadataFieldsConfirm.message("xmlui.administrative.registries.general.metadata_registry_trail");
    private static final Message T_trail = DeleteMetadataFieldsConfirm.message("xmlui.administrative.registries.DeleteMetadataFieldsConfirm.trail");
    private static final Message T_head = DeleteMetadataFieldsConfirm.message("xmlui.administrative.registries.DeleteMetadataFieldsConfirm.head");
    private static final Message T_para1 = DeleteMetadataFieldsConfirm.message("xmlui.administrative.registries.DeleteMetadataFieldsConfirm.para1");
    private static final Message T_warning = DeleteMetadataFieldsConfirm.message("xmlui.administrative.registries.DeleteMetadataFieldsConfirm.warning");
    private static final Message T_para2 = DeleteMetadataFieldsConfirm.message("xmlui.administrative.registries.DeleteMetadataFieldsConfirm.para2");
    private static final Message T_column1 = DeleteMetadataFieldsConfirm.message("xmlui.administrative.registries.DeleteMetadataFieldsConfirm.column1");
    private static final Message T_column2 = DeleteMetadataFieldsConfirm.message("xmlui.administrative.registries.DeleteMetadataFieldsConfirm.column2");
    private static final Message T_column3 = DeleteMetadataFieldsConfirm.message("xmlui.administrative.registries.DeleteMetadataFieldsConfirm.column3");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/metadata-registry", T_metadata_registry_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        String idsString = this.parameters.getParameter("fieldIDs", null);
        ArrayList<MetadataField> fields = new ArrayList<MetadataField>();
        for (String id : idsString.split(",")) {
            MetadataField field = MetadataField.find((Context)this.context, (int)Integer.valueOf(id));
            fields.add(field);
        }
        Division deleted = body.addInteractiveDivision("metadata-field-confirm-delete", this.contextPath + "/admin/metadata-registry", "post", "primary administrative metadata-registry");
        deleted.setHead(T_head);
        deleted.addPara(T_para1);
        Para warning = deleted.addPara();
        warning.addHighlight("bold").addContent(T_warning);
        warning.addContent(T_para2);
        Table table = deleted.addTable("field-confirm-delete", fields.size() + 1, 3);
        Row header = table.addRow("header");
        header.addCell().addContent(T_column1);
        header.addCell().addContent(T_column2);
        header.addCell().addContent(T_column3);
        for (MetadataField field : fields) {
            if (field == null) continue;
            String fieldID = String.valueOf(field.getFieldID());
            String fieldEelement = field.getElement();
            String fieldQualifier = field.getQualifier();
            MetadataSchema schema = MetadataSchema.find((Context)this.context, (int)field.getSchemaID());
            String schemaName = schema.getName();
            StringBuilder fieldName = new StringBuilder().append(schemaName).append(".").append(fieldEelement);
            if (fieldQualifier != null && fieldQualifier.length() > 0) {
                fieldName.append(".").append(fieldQualifier);
            }
            String fieldScopeNote = field.getScopeNote();
            Row row = table.addRow();
            row.addCell().addContent(fieldID);
            row.addCell().addContent(fieldName.toString());
            row.addCell().addContent(fieldScopeNote);
        }
        Para buttons = deleted.addPara();
        buttons.addButton("submit_confirm").setValue(T_submit_delete);
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
        deleted.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

