/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.registries;

import java.sql.SQLException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.content.BitstreamFormat;
import org.dspace.core.Context;

public class FormatRegistryMain
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = FormatRegistryMain.message("xmlui.general.dspace_home");
    private static final Message T_title = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.title");
    private static final Message T_format_registry_trail = FormatRegistryMain.message("xmlui.administrative.registries.general.format_registry_trail");
    private static final Message T_head = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.head");
    private static final Message T_para1 = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.para1");
    private static final Message T_new_link = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.new_link");
    private static final Message T_column1 = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.column1");
    private static final Message T_column2 = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.column2");
    private static final Message T_column3 = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.column3");
    private static final Message T_column4 = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.column4");
    private static final Message T_column5 = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.column5");
    private static final Message T_internal = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.internal");
    private static final Message T_support_0 = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.support_0");
    private static final Message T_support_1 = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.support_1");
    private static final Message T_support_2 = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.support_2");
    private static final Message T_submit_delete = FormatRegistryMain.message("xmlui.administrative.registries.FormatRegistryMain.submit_delete");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(null, T_format_registry_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException {
        int highlightID = this.parameters.getParameterAsInteger("highlightID", -1);
        BitstreamFormat[] formats = BitstreamFormat.findAll((Context)this.context);
        String addURL = this.contextPath + "/admin/format-registry?administrative-continue=" + this.knot.getId() + "&submit_add";
        Division main = body.addInteractiveDivision("bitstream-format-registry", this.contextPath + "/admin/format-registry", "post", "primary administrative format-registry");
        main.setHead(T_head);
        main.addPara(T_para1);
        main.addPara().addXref(addURL, T_new_link);
        Table table = main.addTable("bitstream-format-registry", formats.length + 1, 5);
        Row header = table.addRow("header");
        header.addCellContent(T_column1);
        header.addCellContent(T_column2);
        header.addCellContent(T_column3);
        header.addCellContent(T_column4);
        header.addCellContent(T_column5);
        block5: for (BitstreamFormat format : formats) {
            String id = String.valueOf(format.getID());
            String mimeType = format.getMIMEType();
            String name = format.getShortDescription();
            int supportLevel = format.getSupportLevel();
            boolean internal = format.isInternal();
            boolean highlight = false;
            if (format.getID() == highlightID) {
                highlight = true;
            }
            String url = this.contextPath + "/admin/format-registry?administrative-continue=" + this.knot.getId() + "&submit_edit&formatID=" + id;
            Row row = highlight ? table.addRow(null, null, "highlight") : table.addRow();
            Cell cell = row.addCell();
            if (format.getID() > 1) {
                CheckBox select = cell.addCheckBox("select_format");
                select.setLabel(id);
                select.addOption(id);
            }
            row.addCell().addContent(id);
            row.addCell().addXref(url, name);
            cell = row.addCell();
            cell.addXref(url, mimeType);
            if (internal) {
                cell.addContent(" ");
                cell.addContent(T_internal);
            }
            switch (supportLevel) {
                case 0: {
                    row.addCell().addXref(url, T_support_0);
                    continue block5;
                }
                case 1: {
                    row.addCell().addXref(url, T_support_1);
                    continue block5;
                }
                case 2: {
                    row.addCell().addXref(url, T_support_2);
                }
            }
        }
        main.addPara().addButton("submit_delete").setValue(T_submit_delete);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

