/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.environment.Request;
import org.apache.oro.text.perl.Perl5Util;
import org.dspace.app.xmlui.utils.UIException;

public class AdvancedSearchUtils {
    private static final int FIELD_MAX_COUNT = 12;

    public static String buildQuery(List<SearchField> fields) {
        Perl5Util util = new Perl5Util();
        StringBuilder query = new StringBuilder();
        query.append("(");
        for (SearchField field : fields) {
            if (field.getQuery() == null) continue;
            if (fields.indexOf(field) > 0) {
                query.append(" ").append(field.getConjunction()).append(" ");
            }
            if ("ANY".equals(field.getField())) {
                query.append("(").append(field.getQuery()).append(")");
                continue;
            }
            String subQuery = util.substitute("s/'(.*)'/\"$1\"/g", field.getQuery());
            if (!util.match("/\".*\"/", subQuery)) {
                subQuery = util.substitute("s/[ ]+/ " + field.getField() + ":/g", subQuery);
            }
            query.append("(").append(field.getField()).append(":").append(subQuery).append(")");
        }
        if (query.length() == 1) {
            return "";
        }
        return query.append(")").toString();
    }

    public static List<SearchField> getSearchFields(Request request) throws UIException {
        int numSearchField;
        try {
            String numSearchFieldStr = request.getParameter("num_search_field");
            numSearchField = Integer.valueOf(numSearchFieldStr);
        }
        catch (NumberFormatException nfe) {
            numSearchField = 12;
        }
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        for (int i = 1; i <= numSearchField; ++i) {
            String field = request.getParameter("field" + i);
            String query = AdvancedSearchUtils.decodeFromURL(request.getParameter("query" + i));
            String conjunction = request.getParameter("conjunction" + i);
            if (field != null && (field = field.trim()).length() == 0) {
                field = null;
            }
            if (query != null && (query = query.trim()).length() == 0) {
                query = null;
            }
            if (conjunction != null && (conjunction = conjunction.trim()).length() == 0) {
                conjunction = null;
            }
            if (field == null) {
                field = "ANY";
            }
            if (conjunction == null) {
                conjunction = "AND";
            }
            if (query == null) continue;
            fields.add(new SearchField(i, field, query, conjunction));
        }
        return fields;
    }

    private static String decodeFromURL(String encodedString) throws UIException {
        if (encodedString == null) {
            return null;
        }
        try {
            if (encodedString.contains("%")) {
                encodedString = encodedString.replace("%", "%25");
            }
            return URLDecoder.decode(encodedString, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new UIException(uee);
        }
    }

    public static class SearchField {
        private int index;
        private String field;
        private String query;
        private String conjuction;

        public SearchField(int index, String field, String query, String conjunction) {
            this.index = index;
            this.field = field;
            this.query = query;
            this.conjuction = conjunction;
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }

        public String getQuery() {
            return this.query;
        }

        public String getConjunction() {
            return this.conjuction;
        }
    }
}

