/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.xml.sax.SAXException;

public class CollectionSearch
extends AbstractDSpaceTransformer {
    private static final Message T_full_text_search = CollectionSearch.message("xmlui.ArtifactBrowser.CollectionViewer.full_text_search");
    private static final Message T_go = CollectionSearch.message("xmlui.general.go");
    private static final Message T_advanced_search_link = CollectionSearch.message("xmlui.ArtifactBrowser.CollectionViewer.advanced_search_link");

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (!(dso instanceof Collection)) {
            return;
        }
        Collection collection = (Collection)dso;
        Division home = body.addDivision("collection-home", "primary repository collection");
        Division search = home.addDivision("collection-search-browse", "secondary search-browse");
        Division query = search.addInteractiveDivision("collection-search", this.contextPath + "/handle/" + collection.getHandle() + "/search", "post", "secondary search");
        Para para = query.addPara("search-query", null);
        para.addContent(T_full_text_search);
        para.addContent(" ");
        para.addText("query");
        para.addContent(" ");
        para.addButton("submit").setValue(T_go);
        query.addPara().addXref(this.contextPath + "/handle/" + collection.getHandle() + "/advanced-search", T_advanced_search_link);
    }
}

