/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.xml.sax.SAXException;

public class CommunityRecentSubmissions
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(CommunityRecentSubmissions.class);
    private static final Message T_head_recent_submissions = CommunityRecentSubmissions.message("xmlui.ArtifactBrowser.CommunityViewer.head_recent_submissions");
    private static final int RECENT_SUBMISSIONS = 5;
    private List<BrowseItem> recentSubmittedItems;
    private SourceValidity validity;

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            Community community = null;
            try {
                DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
                if (dso == null) {
                    return null;
                }
                if (!(dso instanceof Community)) {
                    return null;
                }
                community = (Community)dso;
                DSpaceValidity validity = new DSpaceValidity();
                validity.add((DSpaceObject)community);
                for (BrowseItem item : this.getRecentlySubmittedItems(community)) {
                    validity.add((DSpaceObject)item);
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (!(dso instanceof Community)) {
            return;
        }
        Community community = (Community)dso;
        Division home = body.addDivision("community-home", "primary repository community");
        List<BrowseItem> items = this.getRecentlySubmittedItems(community);
        if (items.size() == 0) {
            return;
        }
        Division lastSubmittedDiv = home.addDivision("community-recent-submission", "secondary recent-submission");
        lastSubmittedDiv.setHead(T_head_recent_submissions);
        ReferenceSet lastSubmitted = lastSubmittedDiv.addReferenceSet("collection-last-submitted", "summaryList", null, "recent-submissions");
        for (BrowseItem item : items) {
            lastSubmitted.addReference(item);
        }
    }

    private List<BrowseItem> getRecentlySubmittedItems(Community community) throws SQLException {
        if (this.recentSubmittedItems != null) {
            return this.recentSubmittedItems;
        }
        String source = ConfigurationManager.getProperty((String)"recent.submissions.sort-option");
        int numRecentSubmissions = ConfigurationManager.getIntProperty((String)"recent.submissions.count", (int)5);
        if (numRecentSubmissions == 0) {
            return new ArrayList<BrowseItem>();
        }
        BrowserScope scope = new BrowserScope(this.context);
        scope.setCommunity(community);
        scope.setResultsPerPage(numRecentSubmissions);
        try {
            scope.setBrowseIndex(BrowseIndex.getItemBrowseIndex());
            for (SortOption so : SortOption.getSortOptions()) {
                if (!so.getName().equals(source)) continue;
                scope.setSortBy(so.getNumber());
                scope.setOrder("DESC");
            }
            BrowseEngine be = new BrowseEngine(this.context);
            this.recentSubmittedItems = be.browse(scope).getResults();
        }
        catch (SortException se) {
            log.error((Object)"Caught SortException", (Throwable)se);
        }
        catch (BrowseException bex) {
            log.error((Object)"Caught BrowseException", (Throwable)bex);
        }
        return this.recentSubmittedItems;
    }

    @Override
    public void recycle() {
        this.recentSubmittedItems = null;
        this.validity = null;
        super.recycle();
    }
}

