/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.xml.sax.SAXException;

public class RelatedItems
extends AbstractDSpaceTransformer {
    private static final Message T_head = RelatedItems.message("xmlui.Discovery.RelatedItems.head");
    private static final Message T_related_help = RelatedItems.message("xmlui.Discovery.RelatedItems.help");

    @Override
    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        List relatedItems;
        DSpaceObject dspaceObject = HandleUtil.obtainHandle(this.objectModel);
        if (!(dspaceObject instanceof Item)) {
            return;
        }
        Item item = (Item)dspaceObject;
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)item);
        if (discoveryConfiguration != null && discoveryConfiguration.getMoreLikeThisConfiguration() != null && CollectionUtils.isNotEmpty((Collection)(relatedItems = SearchUtils.getSearchService().getRelatedItems(this.context, item, discoveryConfiguration.getMoreLikeThisConfiguration())))) {
            Division mltDiv = body.addDivision("item-related-container").addDivision("item-related", "secondary related");
            mltDiv.setHead(T_head);
            mltDiv.addPara(T_related_help);
            ReferenceSet set = mltDiv.addReferenceSet("item-related-items", "summaryList", null, "related-items");
            for (Item dso : relatedItems) {
                set.addReference(dso);
            }
        }
    }

    @Override
    public void recycle() {
        super.recycle();
    }
}

