/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

public class SiteViewer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    public static final Message T_dspace_home = SiteViewer.message("xmlui.general.dspace_home");
    private static final Message T_head = SiteViewer.message("xmlui.ArtifactBrowser.FrontPageSearch.head");
    private static final Message T_para1 = SiteViewer.message("xmlui.ArtifactBrowser.FrontPageSearch.para1");
    private static final Message T_go = SiteViewer.message("xmlui.general.go");

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_dspace_home);
        pageMeta.addTrailLink(this.contextPath, T_dspace_home);
        String formats = ConfigurationManager.getProperty((String)"webui.feed.formats");
        if (formats != null) {
            for (String format : formats.split(",")) {
                String[] parts = format.split("_");
                if (parts.length < 1) continue;
                String feedFormat = parts[0].trim() + "+xml";
                String feedURL = this.contextPath + "/feed/" + format.trim() + "/site";
                pageMeta.addMetadata("feed", feedFormat).addContent(feedURL);
            }
        }
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Division search = body.addInteractiveDivision("front-page-search", this.contextPath + "/discover", "get", "primary");
        search.setHead(T_head);
        search.addPara(T_para1);
        Para fields = search.addPara();
        fields.addText("query");
        fields.addButton("submit").setValue(T_go);
    }
}

