/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.eperson;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.app.xmlui.wing.element.UserMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_my_account = Navigation.message("xmlui.EPerson.Navigation.my_account");
    private static final Message T_profile = Navigation.message("xmlui.EPerson.Navigation.profile");
    private static final Message T_logout = Navigation.message("xmlui.EPerson.Navigation.logout");
    private static final Message T_login = Navigation.message("xmlui.EPerson.Navigation.login");
    private static final Message T_register = Navigation.message("xmlui.EPerson.Navigation.register");
    private SourceValidity validity;

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (request.getParameter("login_email") != null || request.getParameter("login_password") != null || request.getParameter("login_realm") != null) {
            return null;
        }
        if (request.getSitemapURI().length() == 0) {
            return null;
        }
        StringBuilder key = this.context.getCurrentUser() != null ? new StringBuilder(this.context.getCurrentUser().getEmail()) : new StringBuilder("anonymous");
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            key.append("-").append(locale.toString());
        }
        return Long.valueOf(HashUtil.hash((String)key.toString()));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            if (this.context.getCurrentUser() != null) {
                try {
                    Group[] groups;
                    DSpaceValidity validity = new DSpaceValidity();
                    validity.add((DSpaceObject)this.eperson);
                    for (Group group : groups = Group.allMemberGroups((Context)this.context, (EPerson)this.eperson)) {
                        validity.add((DSpaceObject)group);
                    }
                    this.validity = validity.complete();
                }
                catch (SQLException sQLException) {}
            } else {
                this.validity = NOPValidity.SHARED_INSTANCE;
            }
        }
        return this.validity;
    }

    @Override
    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        options.addList("browse");
        List account = options.addList("account");
        options.addList("context");
        options.addList("administrative");
        account.setHead(T_my_account);
        EPerson eperson = this.context.getCurrentUser();
        if (eperson != null) {
            String fullName = eperson.getFullName();
            account.addItemXref(this.contextPath + "/logout", T_logout);
            account.addItemXref(this.contextPath + "/profile", T_profile.parameterize(fullName));
        } else {
            account.addItemXref(this.contextPath + "/login", T_login);
            if (ConfigurationManager.getBooleanProperty((String)"xmlui.user.registration", (boolean)true)) {
                account.addItemXref(this.contextPath + "/register", T_register);
            }
        }
    }

    @Override
    public void addUserMeta(UserMeta userMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        EPerson eperson = this.context.getCurrentUser();
        if (eperson != null) {
            userMeta.setAuthenticated(true);
            userMeta.addMetadata("identifier").addContent(eperson.getID());
            userMeta.addMetadata("identifier", "email").addContent(eperson.getEmail());
            userMeta.addMetadata("identifier", "firstName").addContent(eperson.getFirstName());
            userMeta.addMetadata("identifier", "lastName").addContent(eperson.getLastName());
            userMeta.addMetadata("identifier", "logoutURL").addContent(this.contextPath + "/logout");
            userMeta.addMetadata("identifier", "url").addContent(this.contextPath + "/profile");
        } else {
            userMeta.setAuthenticated(false);
        }
        userMeta.addMetadata("identifier", "loginURL").addContent(this.contextPath + "/login");
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            userMeta.addMetadata("language", "RFC3066").addContent(locale.toString());
        }
    }

    @Override
    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

