/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.aspect.submission.submit.AccessStepUtil;
import org.dspace.app.xmlui.aspect.submission.submit.EditPolicyStep;
import org.dspace.app.xmlui.aspect.submission.submit.LicenseStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

public class AccessStep
extends AbstractSubmissionStep {
    private static final Logger log = Logger.getLogger(LicenseStep.class);
    protected static final Message T_head = AccessStep.message("xmlui.Submission.submit.AccessStep.head");
    protected static final Message T_submit_add_policy = AccessStep.message("xmlui.Submission.submit.AccessStep.submit_add_policy");
    protected static final Message T_private_settings = AccessStep.message("xmlui.Submission.submit.AccessStep.private_settings");
    protected static final Message T_private_settings_help = AccessStep.message("xmlui.Submission.submit.AccessStep.private_settings_help");
    public static final int CHECKBOX_PRIVATE_ITEM = 1;
    public static final int RADIO_OPEN_ACCESS_ITEM_VISIBLE = 0;
    public static final int RADIO_OPEN_ACCESS_ITEM_EMBARGOED = 1;
    private EditPolicyStep editPolicy = null;

    public AccessStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        if (this.errorFlag == 10 || this.errorFlag == 5) {
            this.editPolicy = new EditPolicyStep();
            this.editPolicy.setup(resolver, objectModel, src, parameters);
        }
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("javascript", "static").addContent("static/js/accessFormUtil.js");
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        if (this.editPolicy != null) {
            this.editPolicy.addBody(body);
            return;
        }
        Item item = this.submission.getItem();
        Collection collection = this.submission.getCollection();
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Division div = this.addMainDivision(body, collection);
        AccessStepUtil asu = new AccessStepUtil(this.context);
        asu.addTablePolicies(div, (DSpaceObject)item);
        List form = div.addList("submit-access-settings", "form");
        form.setHead(T_head);
        this.addPrivateCheckBox(request, form, item);
        asu.addName(request.getParameter("name"), form, this.errorFlag);
        asu.addListGroups(request.getParameter("group_id"), form, this.errorFlag, collection);
        asu.addAccessRadios(request.getParameter("open_access_radios"), request.getParameter("embargo_until_date"), form, this.errorFlag, (DSpaceObject)item);
        asu.addReason(request.getParameter("reason"), form, this.errorFlag);
        boolean isAdvancedFormEnabled = ConfigurationManager.getBooleanProperty((String)"xmlui.submission.restrictstep.enableAdvancedForm", (boolean)false);
        if (isAdvancedFormEnabled) {
            Button addPolicy = form.addItem().addButton("submit_add_policy");
            addPolicy.setValue(T_submit_add_policy);
        }
        this.addControlButtons(form);
    }

    private void addPrivateCheckBox(Request request, List form, Item item) throws WingException {
        CheckBox privateCheckbox = form.addItem().addCheckBox("private_option");
        privateCheckbox.setLabel(T_private_settings);
        privateCheckbox.setHelp(T_private_settings_help);
        if (request.getParameter("private_option") != null || !item.isDiscoverable()) {
            privateCheckbox.addOption(true, 1, "");
        } else {
            privateCheckbox.addOption(false, 1, "");
        }
    }

    private Division addMainDivision(Body body, Collection collection) throws WingException {
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        Division div = body.addInteractiveDivision("submit-restrict", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        return div;
    }

    @Override
    public List addReviewSection(List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        return null;
    }
}

