/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Radio;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.license.CCLicense;
import org.dspace.license.CCLicenseField;
import org.dspace.license.CCLookup;
import org.dspace.license.CreativeCommons;
import org.xml.sax.SAXException;

public class CCLicenseStep
extends AbstractSubmissionStep {
    protected static final Message T_head = CCLicenseStep.message("xmlui.Submission.submit.CCLicenseStep.head");
    protected static final Message T_select = CCLicenseStep.message("xmlui.Submission.submit.CCLicenseStep.submit_choose_creative_commons");
    protected static final Message T_info1 = CCLicenseStep.message("xmlui.Submission.submit.CCLicenseStep.info1");
    protected static final Message T_submit_to_creative_commons = CCLicenseStep.message("xmlui.Submission.submit.CCLicenseStep.submit_to_creative_commons");
    protected static final Message T_submit_issue_creative_commons = CCLicenseStep.message("xmlui.Submission.submit.CCLicenseStep.submit_issue_creative_commons");
    protected static final Message T_license = CCLicenseStep.message("xmlui.Submission.submit.CCLicenseStep.license");
    protected static final Message T_submit_remove = CCLicenseStep.message("xmlui.Submission.submit.CCLicenseStep.submit_remove");
    protected static final Message T_no_license = CCLicenseStep.message("xmlui.Submission.submit.CCLicenseStep.no_license");
    protected static final Message T_select_change = CCLicenseStep.message("xmlui.Submission.submit.CCLicenseStep.select_change");
    protected static final Message T_save_changes = CCLicenseStep.message("xmlui.Submission.submit.CCLicenseStep.save_changes");
    protected static final Message T_ccws_error = CCLicenseStep.message("xmlui.Submission.submit.CCLicenseStep.ccws_error");

    public CCLicenseStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Item item = this.submission.getItem();
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        boolean https = request.isSecure();
        String server = request.getServerName();
        int port = request.getServerPort();
        String exitURL = https ? "https://" : "http://";
        exitURL = exitURL + server;
        if (port != 80 && port != 443) {
            exitURL = exitURL + ":" + port;
        }
        exitURL = exitURL + actionURL + "?submission-continue=" + this.knot.getId() + "&cc_license_url=[license_url]";
        Division div = body.addInteractiveDivision("submit-cclicense", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        CCLookup cclookup = new CCLookup();
        HttpSession session = request.getSession();
        String selectedLicense = request.getParameter("licenseclass_chooser");
        List list = div.addList("licenseclasslist", "form");
        list.addItem(T_info1);
        list.setHead(T_head);
        list.addItem().addHidden("button_required");
        Select selectList = list.addItem().addSelect("licenseclass_chooser");
        selectList.setLabel(T_license);
        selectList.setEvtBehavior("submitOnChange");
        Iterator iterator = cclookup.getLicenses(ConfigurationManager.getProperty((String)"default.locale")).iterator();
        selectList.addOption(T_select_change.getKey(), T_select_change);
        while (iterator.hasNext()) {
            CCLicense cclicense = (CCLicense)iterator.next();
            selectList.addOption(cclicense.getLicenseId(), cclicense.getLicenseName());
            if (selectedLicense == null || !selectedLicense.equals(cclicense.getLicenseId())) continue;
            selectList.setOptionSelected(cclicense.getLicenseId());
        }
        selectList.addOption(T_no_license.getKey(), T_no_license);
        if (selectedLicense != null && cclookup.getLicenseFields(selectedLicense) != null) {
            for (CCLicenseField cclicensefield : cclookup.getLicenseFields(selectedLicense)) {
                if (cclicensefield.getId().equals("jurisdiction")) continue;
                List edit = div.addList("selectlist", "simple", "horizontalVanilla");
                edit.addItem(cclicensefield.getLabel());
                edit.addItem().addFigure(this.contextPath + "/themes/Reference/images/information.png", "javascript:void(0)", cclicensefield.getDescription(), "information");
                List subList = div.addList("sublist", "simple", "horizontalVanilla");
                Radio radio = subList.addItem().addRadio(cclicensefield.getId() + "_chooser");
                radio.setRequired();
                for (Map.Entry pairs : cclicensefield.getEnum().entrySet()) {
                    String key = (String)pairs.getKey();
                    String value = (String)pairs.getValue();
                    radio.addOption(key, value);
                }
                div.addSimpleHTMLFragment(true, "&#160;");
            }
        }
        Division statusDivision = div.addDivision("statusDivision");
        List statusList = statusDivision.addList("statusList", "form");
        String licenseUri = CreativeCommons.getCCField((String)"uri").ccItemValue(item);
        if (licenseUri != null) {
            statusList.addItem().addXref(licenseUri, licenseUri);
        } else if (session.getAttribute("isFieldRequired") != null && session.getAttribute("isFieldRequired").equals("TRUE") && session.getAttribute("ccError") != null) {
            statusList.addItem().addHighlight("error").addContent(T_ccws_error.parameterize((String)session.getAttribute("ccError")));
            session.removeAttribute("ccError");
            session.removeAttribute("isFieldRequired");
        } else if (session.getAttribute("inProgress") != null && ((String)session.getAttribute("inProgress")).equals("TRUE")) {
            statusList.addItem().addHighlight("italic").addContent(T_save_changes);
        }
        this.addControlButtons(statusList);
    }

    @Override
    public List addReviewSection(List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        return null;
    }

    @Override
    public void recycle() {
        super.recycle();
    }
}

