/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.aspect.submission.AbstractStep;
import org.dspace.app.xmlui.aspect.submission.submit.AccessStepUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

public class EditBitstreamPolicies
extends AbstractStep {
    protected static final Message T_head = EditBitstreamPolicies.message("xmlui.Submission.submit.EditBitstreamPolicies.head");
    protected static final Message T_submit_save = EditBitstreamPolicies.message("xmlui.general.save");
    protected static final Message T_submit_add_policy = EditBitstreamPolicies.message("xmlui.Submission.submit.AccessStep.submit_add_policy");

    public EditBitstreamPolicies() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Division div = body.addInteractiveDivision("submit-edit-bitstream-policy", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        AccessStepUtil asu = new AccessStepUtil(this.context);
        asu.addTablePolicies(div, (DSpaceObject)this.submissionInfo.getBitstream());
        List form = div.addList("submit-edit-policy", "form");
        form.setHead(T_head);
        asu.addName(request.getParameter("name"), form, this.errorFlag);
        asu.addListGroups(request.getParameter("group_id"), form, this.errorFlag, collection);
        asu.addAccessRadios(request.getParameter("open_access_radios"), request.getParameter("embargo_until_date"), form, this.errorFlag, (DSpaceObject)this.submissionInfo.getBitstream());
        asu.addReason(request.getParameter("reason"), form, this.errorFlag);
        boolean isAdvancedFormEnabled = ConfigurationManager.getBooleanProperty((String)"xmlui.submission.restrictstep.enableAdvancedForm", (boolean)false);
        if (isAdvancedFormEnabled) {
            Button addPolicy = form.addItem().addButton("submit_add_policy");
            addPolicy.setValue(T_submit_add_policy);
        }
        div.addHidden("bitstream_id").setValue(this.submissionInfo.getBitstream().getID());
        Item actions = form.addItem();
        actions.addButton("bitstream_list_submit_save").setValue(T_submit_save);
    }
}

