/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.xml.sax.SAXException;

public class SelectCollectionStep
extends AbstractSubmissionStep {
    protected static final Message T_head = SelectCollectionStep.message("xmlui.Submission.submit.SelectCollection.head");
    protected static final Message T_collection = SelectCollectionStep.message("xmlui.Submission.submit.SelectCollection.collection");
    protected static final Message T_collection_help = SelectCollectionStep.message("xmlui.Submission.submit.SelectCollection.collection_help");
    protected static final Message T_collection_default = SelectCollectionStep.message("xmlui.Submission.submit.SelectCollection.collection_default");
    protected static final Message T_submit_next = SelectCollectionStep.message("xmlui.general.next");

    public SelectCollectionStep() {
        this.requireHandle = true;
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException {
        pageMeta.addMetadata("title").addContent(T_submission_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_submission_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String actionURL = this.contextPath + "/submit/" + this.knot.getId() + ".continue";
        DSpaceObject dso = HandleManager.resolveToObject((Context)this.context, (String)this.handle);
        Collection[] collections = dso instanceof Community ? Collection.findAuthorized((Context)this.context, (Community)((Community)dso), (int)3) : Collection.findAuthorized((Context)this.context, null, (int)3);
        Division div = body.addInteractiveDivision("select-collection", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        List list = div.addList("select-collection", "form");
        list.setHead(T_head);
        Select select = list.addItem().addSelect("handle");
        select.setAutofocus("autofocus");
        select.setLabel(T_collection);
        select.setHelp(T_collection_help);
        select.addOption("", T_collection_default);
        for (Collection collection : collections) {
            String name = collection.getMetadata("name");
            select.addOption(collection.getHandle(), name);
        }
        Button submit = list.addItem().addButton("submit");
        submit.setValue(T_submit_next);
    }

    @Override
    public List addReviewSection(List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        return null;
    }

    @Override
    public void recycle() {
        this.handle = null;
        super.recycle();
    }
}

