/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.sql.SQLException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class VersionHistoryForm
extends AbstractDSpaceTransformer {
    private static final Message T_head2 = VersionHistoryForm.message("xmlui.aspect.versioning.VersionHistoryForm.head2");
    private static final Message T_column1 = VersionHistoryForm.message("xmlui.aspect.versioning.VersionHistoryForm.column1");
    private static final Message T_column2 = VersionHistoryForm.message("xmlui.aspect.versioning.VersionHistoryForm.column2");
    private static final Message T_column3 = VersionHistoryForm.message("xmlui.aspect.versioning.VersionHistoryForm.column3");
    private static final Message T_column4 = VersionHistoryForm.message("xmlui.aspect.versioning.VersionHistoryForm.column4");
    private static final Message T_column5 = VersionHistoryForm.message("xmlui.aspect.versioning.VersionHistoryForm.column5");
    private static final Message T_column6 = VersionHistoryForm.message("xmlui.aspect.versioning.VersionHistoryForm.column6");
    private static final Message T_submit_update = VersionHistoryForm.message("xmlui.aspect.versioning.VersionHistoryForm.update");
    private static final Message T_submit_cancel = VersionHistoryForm.message("xmlui.aspect.versioning.VersionHistoryForm.return");
    private static final Message T_submit_delete = VersionHistoryForm.message("xmlui.aspect.versioning.VersionHistoryForm.delete");
    private static final Message T_legend = VersionHistoryForm.message("xmlui.aspect.versioning.VersionHistoryForm.legend");

    @Override
    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        VersionHistory versionHistory;
        boolean isItemView = this.parameters.getParameterAsInteger("itemID", -1) == -1;
        Item item = this.getItem();
        if (item == null || !AuthorizeManager.isAdmin((Context)this.context, (DSpaceObject)item.getOwningCollection())) {
            if (isItemView) {
                if (((Boolean)new DSpace().getConfigurationService().getPropertyAsType("versioning.item.history.view.admin", (Object)false)).booleanValue()) {
                    return;
                }
            } else {
                throw new AuthorizeException();
            }
        }
        if ((versionHistory = this.retrieveVersionHistory(item)) != null) {
            Division main = this.createMain(body);
            this.createTable(main, versionHistory, isItemView, item);
            if (!isItemView) {
                this.addButtons(main, versionHistory);
                main.addHidden("versioning-continue").setValue(this.knot.getId());
            }
            Para note = main.addPara();
            note.addContent(T_legend);
        }
    }

    private Item getItem() throws WingException {
        try {
            if (this.parameters.getParameterAsInteger("itemID", -1) == -1) {
                DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
                if (!(dso instanceof Item)) {
                    return null;
                }
                return (Item)dso;
            }
            return Item.find((Context)this.context, (int)this.parameters.getParameterAsInteger("itemID", -1));
        }
        catch (SQLException e) {
            throw new WingException(e);
        }
    }

    private VersionHistory retrieveVersionHistory(Item item) throws WingException {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        return versioningService.findVersionHistory(this.context, item.getID());
    }

    private Division createMain(Body body) throws WingException {
        Division main = body.addInteractiveDivision("view-verion-history", this.contextPath + "/item/versionhistory", "post", "view version history");
        main.setHead(T_head2);
        return main;
    }

    private void createTable(Division main, VersionHistory history, boolean isItemView, Item item) throws WingException, SQLException {
        Table table = main.addTable("versionhistory", 1, 1);
        Row header = table.addRow("header");
        if (!isItemView) {
            header.addCell().addContent("");
        }
        header.addCell().addContent(T_column1);
        header.addCell().addContent(T_column2);
        header.addCell().addContent(T_column3);
        header.addCell().addContent(T_column4);
        header.addCell().addContent(T_column5);
        if (!isItemView) {
            header.addCell().addContent(T_column6);
        }
        if (history != null) {
            for (Version version : history.getVersions()) {
                if (this.isItemInSubmission(version.getItem())) continue;
                Row row = table.addRow(null, "data", "metadata-value");
                if (!isItemView) {
                    CheckBox remove = row.addCell().addCheckBox("remove");
                    remove.setLabel("remove");
                    remove.addOption(version.getVersionId());
                }
                row.addCell().addContent(version.getVersionNumber());
                this.addItemIdentifier(row.addCell(), item, version);
                EPerson editor = version.getEperson();
                row.addCell().addXref("mailto:" + editor.getEmail(), editor.getFullName());
                row.addCell().addContent(new DCDate(version.getVersionDate()).toString());
                row.addCell().addContent(version.getSummary());
                if (isItemView) continue;
                row.addCell().addXref(this.contextPath + "/item/versionhistory?versioning-continue=" + this.knot.getId() + "&versionID=" + version.getVersionId() + "&itemID=" + version.getItem().getID() + "&submit_update", T_submit_update);
            }
        }
    }

    private boolean isItemInSubmission(Item item) throws SQLException {
        WorkspaceItem workspaceItem = WorkspaceItem.findByItem((Context)this.context, (Item)item);
        Object workflowItem = ConfigurationManager.getProperty((String)"workflow", (String)"workflow.framework").equals("xmlworkflow") ? XmlWorkflowItem.findByItem((Context)this.context, (Item)item) : WorkflowItem.findByItem((Context)this.context, (Item)item);
        return workspaceItem != null || workflowItem != null;
    }

    private void addItemIdentifier(Cell cell, Item item, Version version) throws WingException {
        String itemHandle = version.getItem().getHandle();
        DCValue[] identifiers = version.getItem().getMetadata("dc", "identifier", null, "*");
        String itemIdentifier = null;
        if (identifiers != null && identifiers.length > 0) {
            itemIdentifier = identifiers[0].value;
        }
        if (itemIdentifier != null) {
            cell.addXref(this.contextPath + "/resource/" + itemIdentifier, itemIdentifier);
        } else {
            cell.addXref(this.contextPath + "/handle/" + itemHandle, itemHandle);
        }
        if (item.getID() == version.getItemID()) {
            cell.addContent("*");
        }
    }

    private void addButtons(Division main, VersionHistory history) throws WingException {
        Para actions = main.addPara();
        if (history != null && history.getVersions().size() > 0) {
            actions.addButton("submit_delete").setValue(T_submit_delete);
        }
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
    }
}

