/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmlworkflow;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_xmlworkflow_overview = Navigation.message("xmlui.XMLWorkflow.Navigation.xmlworkflow_overview");
    private SourceValidity validity;
    List<String> availableExports = null;

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (request.getParameter("login_email") != null || request.getParameter("login_password") != null || request.getParameter("login_realm") != null) {
            return "0";
        }
        if (this.context.getCurrentUser() == null) {
            return Long.valueOf(HashUtil.hash((String)"anonymous"));
        }
        if (this.availableExports != null && this.availableExports.size() > 0) {
            StringBuilder key = new StringBuilder(this.context.getCurrentUser().getEmail());
            for (String fileName : this.availableExports) {
                key.append(":").append(fileName);
            }
            return Long.valueOf(HashUtil.hash((String)key.toString()));
        }
        return Long.valueOf(HashUtil.hash((String)this.context.getCurrentUser().getEmail()));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            if (this.context.getCurrentUser() != null) {
                try {
                    Group[] groups;
                    DSpaceValidity validity = new DSpaceValidity();
                    validity.add((DSpaceObject)this.eperson);
                    for (Group group : groups = Group.allMemberGroups((Context)this.context, (EPerson)this.eperson)) {
                        validity.add((DSpaceObject)group);
                    }
                    this.validity = validity.complete();
                }
                catch (SQLException sQLException) {}
            } else {
                this.validity = NOPValidity.SHARED_INSTANCE;
            }
        }
        return this.validity;
    }

    @Override
    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        org.dspace.app.xmlui.wing.element.List admin = options.addList("administrative");
        boolean isSystemAdmin = AuthorizeManager.isAdmin((Context)this.context);
        if (isSystemAdmin) {
            admin.addItemXref(this.contextPath + "/admin/xmlworkflowoverview", T_xmlworkflow_overview);
        }
    }

    @Override
    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

