/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.sitemap.PatternException;
import org.dspace.app.xmlui.configuration.Aspect;
import org.dspace.app.xmlui.configuration.XMLUIConfiguration;

public class AspectMatcher
extends AbstractLogEnabled
implements Matcher {
    public Map match(String pattern, Map objectModel, Parameters parameters) throws PatternException {
        int aspectID;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String uri = request.getSitemapURI();
        String[] parts = uri.split("/");
        try {
            aspectID = Integer.valueOf(parts[0]);
        }
        catch (NumberFormatException nfe) {
            aspectID = 0;
        }
        if (aspectID == 0) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("aspectID", String.valueOf(aspectID));
            return result;
        }
        List<Aspect> chain = XMLUIConfiguration.getAspectChain();
        if (chain.size() + 1 > aspectID) {
            Aspect aspect = chain.get(aspectID - 1);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("aspectID", String.valueOf(aspectID));
            result.put("aspect", aspect.getPath());
            result.put("aspectName", aspect.getName());
            result.put("prefix", aspectID + "/");
            return result;
        }
        return null;
    }
}

