/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.objectmanager;

import java.sql.SQLException;
import org.dspace.app.xmlui.objectmanager.AbstractAdapter;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.Namespace;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.xml.sax.SAXException;

public class RepositoryAdapter
extends AbstractAdapter {
    public static final String MODS_URI = "http://www.loc.gov/mods/v3";
    public static final Namespace MODS = new Namespace("http://www.loc.gov/mods/v3");
    private String dmdSecIDS;
    private Context context;

    public RepositoryAdapter(Context context, String contextPath) {
        super(contextPath);
        this.context = context;
    }

    @Override
    protected String getMETSID() {
        return HandleManager.getPrefix();
    }

    @Override
    protected String getMETSOBJID() throws WingException {
        if (this.contextPath == null) {
            return "/";
        }
        return this.contextPath + "/";
    }

    @Override
    protected String getMETSOBJEDIT() {
        return null;
    }

    @Override
    protected String getMETSProfile() {
        return "DRI DSPACE Repository Profile 1.0";
    }

    @Override
    protected String getMETSLabel() {
        return "DSpace Repository";
    }

    @Override
    protected void renderDescriptiveSection() throws SAXException {
        String dmdID = this.getGenericID("dmd_");
        String groupID = this.getGenericID("group_dmd_");
        AttributeMap attributes = new AttributeMap();
        attributes.put("ID", dmdID);
        attributes.put("GROUPID", groupID);
        this.startElement(METS, "dmdSec", attributes);
        attributes = new AttributeMap();
        attributes.put("MDTYPE", "OTHER");
        attributes.put("OTHERMDTYPE", "DIM");
        this.startElement(METS, "mdWrap", attributes);
        this.startElement(METS, "xmlData", new AttributeMap[0]);
        attributes = new AttributeMap();
        attributes.put("dspaceType", Constants.typeText[5]);
        this.startElement(DIM, "dim", attributes);
        attributes = new AttributeMap();
        attributes.put("mdschema", "dspace");
        attributes.put("element", "name");
        this.startElement(DIM, "field", attributes);
        this.sendCharacters(ConfigurationManager.getProperty((String)"dspace.name"));
        this.endElement(DIM, "field");
        attributes = new AttributeMap();
        attributes.put("mdschema", "dspace");
        attributes.put("element", "hostname");
        this.startElement(DIM, "field", attributes);
        this.sendCharacters(ConfigurationManager.getProperty((String)"dspace.hostname"));
        this.endElement(DIM, "field");
        attributes = new AttributeMap();
        attributes.put("mdschema", "dspace");
        attributes.put("element", "handle");
        this.startElement(DIM, "field", attributes);
        this.sendCharacters(HandleManager.getPrefix());
        this.endElement(DIM, "field");
        attributes = new AttributeMap();
        attributes.put("mdschema", "dspace");
        attributes.put("element", "default");
        attributes.put("qualifier", "language");
        this.startElement(DIM, "field", attributes);
        this.sendCharacters(ConfigurationManager.getProperty((String)"default.language"));
        this.endElement(DIM, "field");
        this.endElement(DIM, "dim");
        this.endElement(METS, "xmlData");
        this.endElement(METS, "mdWrap");
        this.endElement(METS, "dmdSec");
        this.dmdSecIDS = dmdID;
    }

    @Override
    protected void renderStructureMap() throws SQLException, SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.put("TYPE", "LOGICAL");
        attributes.put("LABEL", "DSpace");
        this.startElement(METS, "structMap", attributes);
        attributes = new AttributeMap();
        attributes.put("TYPE", "DSpace Repository");
        if (this.dmdSecIDS != null) {
            attributes.put("DMDID", this.dmdSecIDS);
        }
        this.startElement(METS, "div", attributes);
        for (Community community : Community.findAllTop((Context)this.context)) {
            this.renderStructuralDiv((DSpaceObject)community);
        }
        this.endElement(METS, "div");
        this.endElement(METS, "structMap");
    }

    private void renderStructuralDiv(DSpaceObject dso) throws SAXException, SQLException {
        AttributeMap attributes = new AttributeMap();
        if (dso instanceof Community) {
            attributes.put("TYPE", "DSpace Community");
        } else if (dso instanceof Collection) {
            attributes.put("TYPE", "DSpace Collection");
        }
        this.startElement(METS, "div", attributes);
        attributes = new AttributeMap();
        AttributeMap attributesXLINK = new AttributeMap();
        attributesXLINK.setNamespace(XLINK);
        attributes.put("LOCTYPE", "URL");
        attributesXLINK.put("href", "/metadata/handle/" + dso.getHandle() + "/mets.xml");
        this.startElement(METS, "mptr", attributes, attributesXLINK);
        this.endElement(METS, "mptr");
        if (dso instanceof Community) {
            for (Collection collection : ((Community)dso).getCollections()) {
                this.renderStructuralDiv((DSpaceObject)collection);
            }
            for (Collection collection : ((Community)dso).getSubcommunities()) {
                this.renderStructuralDiv((DSpaceObject)collection);
            }
        }
        this.endElement(METS, "div");
    }
}

