/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.wing.AbstractWingTransformer;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

public class IncludePageMeta
extends AbstractWingTransformer
implements CacheableProcessingComponent {
    private List<Metadata> metadataList;

    public Serializable getKey() {
        String key = "";
        for (Metadata metadata : this.metadataList) {
            key = "-" + metadata.getName() + "=" + metadata.getValue();
        }
        return Long.valueOf(HashUtil.hash((String)key));
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        try {
            String[] names = parameters.getNames();
            this.metadataList = new ArrayList<Metadata>();
            for (String name : names) {
                String[] nameParts = name.split("#");
                String dcName = null;
                int order = -1;
                if (nameParts.length == 1) {
                    dcName = nameParts[0];
                    order = 1;
                } else if (nameParts.length == 2) {
                    dcName = nameParts[0];
                    order = Integer.valueOf(nameParts[1]);
                } else {
                    throw new ProcessingException("Unable to parse page metadata name, '" + name + "', into parts.");
                }
                String[] dcParts = dcName.split("\\.");
                String element = null;
                String qualifier = null;
                String language = null;
                if (dcParts.length == 1) {
                    element = dcParts[0];
                } else if (dcParts.length == 2) {
                    element = dcParts[0];
                    qualifier = dcParts[1];
                } else if (dcParts.length == 3) {
                    element = dcParts[0];
                    qualifier = dcParts[1];
                    language = dcParts[2];
                } else {
                    throw new ProcessingException("Unable to parse page metadata name, '" + name + "', into parts.");
                }
                String value = parameters.getParameter(name);
                Metadata metadata = new Metadata(element, qualifier, language, order, value);
                this.metadataList.add(metadata);
            }
            Collections.sort(this.metadataList);
        }
        catch (ParameterException pe) {
            throw new ProcessingException((Exception)((Object)pe));
        }
        try {
            this.setupWing();
        }
        catch (WingException we) {
            throw new ProcessingException((Exception)we);
        }
        if (ConfigurationManager.getBooleanProperty((String)"xmlui.theme.enableConcatenation", (boolean)false)) {
            this.metadataList = this.enableConcatenation();
        }
    }

    private List<Metadata> enableConcatenation() {
        Metadata last = null;
        ArrayList<Metadata> newMetadataList = new ArrayList<Metadata>();
        for (Metadata metadata : this.metadataList) {
            String curfile = metadata.getValue();
            if (curfile.lastIndexOf(63) != -1) {
                curfile = curfile.substring(0, curfile.lastIndexOf(63));
            }
            if (curfile.endsWith(".css") || curfile.endsWith(".js") || curfile.endsWith(".json")) {
                String curval = metadata.getValue();
                if (last != null && this.checkConcatenateMerge(last, metadata)) {
                    String lastval = last.getValue();
                    curval = metadata.getValue();
                    String newval = lastval.substring(0, lastval.lastIndexOf(46)) + ",";
                    newval = newval + curval.substring(curval.lastIndexOf(47) + 1, curval.lastIndexOf(46));
                    newval = newval + lastval.substring(lastval.lastIndexOf(46));
                    last.value = newval;
                    continue;
                }
                newMetadataList.add(metadata);
                if (curval.lastIndexOf(63) != -1) {
                    if (curval.substring(curval.lastIndexOf(63)).equals("?nominify")) {
                        last = metadata;
                        continue;
                    }
                    if (curval.substring(curval.lastIndexOf(63)).equals("?noconcat")) {
                        last = null;
                        curval = curval.substring(0, curval.lastIndexOf(63));
                        metadata.value = curval;
                        continue;
                    }
                    last = null;
                    curval = curval.substring(0, curval.lastIndexOf(63)) + "?nominify";
                    metadata.value = curval;
                    continue;
                }
                last = metadata;
                continue;
            }
            newMetadataList.add(metadata);
        }
        return newMetadataList;
    }

    private boolean checkConcatenateMerge(Metadata last, Metadata current) {
        if (last.getElement() == null ? current.getElement() != null : !last.getElement().equals(current.getElement())) {
            return false;
        }
        if (last.getQualifier() == null ? current.getQualifier() != null : !last.getQualifier().equals(current.getQualifier())) {
            return false;
        }
        if (last.getLanguage() == null ? current.getLanguage() != null : !last.getLanguage().equals(current.getLanguage())) {
            return false;
        }
        String curval = current.getValue();
        String lastval = last.getValue();
        if (!lastval.substring(lastval.lastIndexOf(46)).equals(curval.substring(curval.lastIndexOf(46)))) {
            return false;
        }
        if (!lastval.substring(0, lastval.lastIndexOf(47) + 1).equals(curval.substring(0, curval.lastIndexOf(47) + 1))) {
            return false;
        }
        return curval.lastIndexOf(63) == -1 || "?nominify".equals(curval.substring(curval.lastIndexOf(63)));
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        for (Metadata metadata : this.metadataList) {
            String element = metadata.getElement();
            String qualifier = metadata.getQualifier();
            String language = metadata.getLanguage();
            String value = metadata.getValue();
            pageMeta.addMetadata(element, qualifier, language).addContent(value);
        }
    }

    static class Metadata
    implements Comparable<Metadata> {
        private String element;
        private String qualifier;
        private String language;
        private int order;
        private String value;

        public Metadata(String element, String qualifier, String language, int order, String value) {
            this.element = element;
            this.qualifier = qualifier;
            this.language = language;
            this.order = order;
            this.value = value;
        }

        public String getElement() {
            return this.element;
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public String getLanguage() {
            return this.language;
        }

        public int getOrder() {
            return this.order;
        }

        public String getName() {
            String name = this.element;
            if (this.qualifier != null) {
                name = name + "." + this.qualifier;
                if (this.language != null) {
                    name = name + "." + this.language;
                }
            }
            name = name + "#" + this.order;
            return name;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Metadata other) {
            String otherName;
            String myName = this.element + "." + this.qualifier + "." + this.language;
            int result = myName.compareTo(otherName = other.element + "." + other.qualifier + "." + other.language);
            if (result == 0) {
                result = this.order == other.order ? 0 : (this.order > other.order ? 1 : -1);
            }
            return result;
        }
    }
}

