/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dspace.core.ConfigurationManager;
import org.purl.sword.base.Collection;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.SwordAcceptPackaging;
import org.purl.sword.base.Workspace;

public class ServiceDocumentHelper {
    public static List<Collection> getCollections(ServiceDocument serviceDoc) {
        ArrayList<Collection> allCollections = new ArrayList<Collection>();
        List workspaces = serviceDoc.getService().getWorkspacesList();
        for (Workspace ws : workspaces) {
            List collections = ws.getCollections();
            allCollections.addAll(collections);
        }
        return allCollections;
    }

    public static Collection getCollection(ServiceDocument serviceDoc, String location) {
        List<Collection> allCollections = ServiceDocumentHelper.getCollections(serviceDoc);
        for (Collection collection : allCollections) {
            if (!collection.getLocation().equals(location)) continue;
            return collection;
        }
        return null;
    }

    public static String[] getCommonFileTypes(ServiceDocument serviceDoc, String location) {
        String[] serverFTs;
        String FTsString = ConfigurationManager.getProperty((String)"sword-client", (String)"file-types");
        String[] clientFTsArray = FTsString.split(",");
        List<String> clientFTs = Arrays.asList(clientFTsArray);
        ArrayList<String> commonFTs = new ArrayList<String>();
        Collection collection = ServiceDocumentHelper.getCollection(serviceDoc, location);
        for (String serverFT : serverFTs = collection.getAccepts()) {
            if (!clientFTs.contains(serverFT)) continue;
            commonFTs.add(serverFT);
        }
        return commonFTs.toArray(new String[commonFTs.size()]);
    }

    public static String[] getCommonPackageFormats(ServiceDocument serviceDoc, String location) {
        String PFsString = ConfigurationManager.getProperty((String)"sword-client", (String)"package-formats");
        String[] clientPFsArray = PFsString.split(",");
        List<String> clientPFs = Arrays.asList(clientPFsArray);
        ArrayList<String> commonPFs = new ArrayList<String>();
        Collection collection = ServiceDocumentHelper.getCollection(serviceDoc, location);
        List serverPFs = collection.getAcceptPackaging();
        for (SwordAcceptPackaging serverPF : serverPFs) {
            if (!clientPFs.contains(serverPF.getContent())) continue;
            commonPFs.add(serverPF.getContent());
        }
        return commonPFs.toArray(new String[commonPFs.size()]);
    }

    public static String[] getPackageFormats(Collection collection) {
        ArrayList<String> packageFormats = new ArrayList<String>();
        List pfs = collection.getAcceptPackaging();
        for (SwordAcceptPackaging pf : pfs) {
            packageFormats.add(pf.getContent());
        }
        return packageFormats.toArray(new String[pfs.size()]);
    }
}

