/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.community;

import java.sql.SQLException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Community;
import org.dspace.core.Context;

public class DeleteCommunityConfirm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = DeleteCommunityConfirm.message("xmlui.general.dspace_home");
    private static final Message T_title = DeleteCommunityConfirm.message("xmlui.administrative.community.DeleteCommunityConfirm.title");
    private static final Message T_trail = DeleteCommunityConfirm.message("xmlui.administrative.community.DeleteCommunityConfirm.trail");
    private static final Message T_main_head = DeleteCommunityConfirm.message("xmlui.administrative.community.DeleteCommunityConfirm.main_head");
    private static final Message T_main_para = DeleteCommunityConfirm.message("xmlui.administrative.community.DeleteCommunityConfirm.main_para");
    private static final Message T_confirm_item1 = DeleteCommunityConfirm.message("xmlui.administrative.community.DeleteCommunityConfirm.confirm_item1");
    private static final Message T_confirm_item2 = DeleteCommunityConfirm.message("xmlui.administrative.community.DeleteCommunityConfirm.confirm_item2");
    private static final Message T_confirm_item3 = DeleteCommunityConfirm.message("xmlui.administrative.community.DeleteCommunityConfirm.confirm_item3");
    private static final Message T_confirm_item4 = DeleteCommunityConfirm.message("xmlui.administrative.community.DeleteCommunityConfirm.confirm_item4");
    private static final Message T_submit_confirm = DeleteCommunityConfirm.message("xmlui.general.delete");
    private static final Message T_submit_cancel = DeleteCommunityConfirm.message("xmlui.general.cancel");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        int communityID = this.parameters.getParameterAsInteger("communityID", -1);
        Community thisCommunity = Community.find((Context)this.context, (int)communityID);
        Division main = body.addInteractiveDivision("community-confirm-delete", this.contextPath + "/admin/community", "post", "primary administrative community");
        main.setHead(T_main_head.parameterize(communityID));
        main.addPara(T_main_para.parameterize(thisCommunity.getMetadata("name")));
        List deleteConfirmHelp = main.addList("consequences", "bulleted");
        deleteConfirmHelp.addItem(T_confirm_item1);
        deleteConfirmHelp.addItem(T_confirm_item2);
        deleteConfirmHelp.addItem(T_confirm_item3);
        deleteConfirmHelp.addItem(T_confirm_item4);
        Para buttonList = main.addPara();
        buttonList.addButton("submit_confirm").setValue(T_submit_confirm);
        buttonList.addButton("submit_cancel").setValue(T_submit_cancel);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

