/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.group;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.dspace.app.xmlui.aspect.administrative.FlowGroupUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Highlight;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class EditGroupForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = EditGroupForm.message("xmlui.general.dspace_home");
    private static final Message T_group_trail = EditGroupForm.message("xmlui.administrative.group.general.group_trail");
    private static final Message T_title = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.title");
    private static final Message T_trail = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.trail");
    private static final Message T_main_head = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.main_head");
    private static final Message T_collection_para = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.collection_para");
    private static final Message T_community_para = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.community_para");
    private static final Message T_label_name = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.label_name");
    private static final Message T_label_instructions = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.label_instructions");
    private static final Message T_label_search = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.label_search");
    private static final Message T_submit_search_people = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.submit_search_people");
    private static final Message T_submit_search_groups = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.submit_search_groups");
    private static final Message T_no_results = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.no_results");
    private static final Message T_main_head_new = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.main_head_new");
    private static final Message T_submit_clear = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.submit_clear");
    private static final Message T_submit_save = EditGroupForm.message("xmlui.general.save");
    private static final Message T_submit_cancel = EditGroupForm.message("xmlui.general.cancel");
    private static final Message T_member = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.member");
    private static final Message T_cycle = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.cycle");
    private static final Message T_pending = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.pending");
    private static final Message T_pending_warn = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.pending_warn");
    private static final Message T_submit_add = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.submit_add");
    private static final Message T_submit_remove = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.submit_remove");
    private static final Message T_epeople_column1 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.epeople_column1");
    private static final Message T_epeople_column2 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.epeople_column2");
    private static final Message T_epeople_column3 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.epeople_column3");
    private static final Message T_epeople_column4 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.epeople_column4");
    private static final Message T_groups_column1 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.groups_column1");
    private static final Message T_groups_column2 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.groups_column2");
    private static final Message T_groups_column3 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.groups_column3");
    private static final Message T_groups_column4 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.groups_column4");
    private static final Message T_groups_column5 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.groups_column5");
    private static final Message T_groups_collection_link = EditGroupForm.message("xmlui.administrative.group.ManageGroupsMain.groups_collection_link");
    private static final Message T_members_head = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.members_head");
    private static final Message T_members_column1 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.members_column1");
    private static final Message T_members_column2 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.members_column2");
    private static final Message T_members_column3 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.members_column3");
    private static final Message T_members_column4 = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.members_column4");
    private static final Message T_members_group_name = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.members_group_name");
    private static final Message T_members_pending = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.members_pending");
    private static final Message T_members_none = EditGroupForm.message("xmlui.administrative.group.EditGroupForm.members_none");
    private static final int RESULTS_PER_PAGE = 5;
    private static final int MAX_COLLECTION_NAME = 25;

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/groups", T_group_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException {
        int groupID = this.parameters.getParameterAsInteger("groupID", -1);
        String currentName = EditGroupForm.decodeFromURL(this.parameters.getParameter("groupName", null));
        if (currentName == null || currentName.length() == 0) {
            currentName = FlowGroupUtils.getName(this.context, groupID);
        }
        Group group = null;
        if (groupID >= 0) {
            group = Group.find((Context)this.context, (int)groupID);
        }
        Collection collection = null;
        Community community = null;
        if (group != null) {
            int collectionID = FlowGroupUtils.getCollectionId(group.getName());
            if (collectionID > -1) {
                collection = Collection.find((Context)this.context, (int)collectionID);
            } else {
                int communityID = FlowGroupUtils.getCommunityId(group.getName());
                if (communityID > -1) {
                    community = Community.find((Context)this.context, (int)communityID);
                }
            }
        }
        String memberGroupIDsString = this.parameters.getParameter("memberGroupIDs", null);
        ArrayList<Integer> memberGroupIDs = new ArrayList<Integer>();
        if (memberGroupIDsString != null) {
            for (String id : memberGroupIDsString.split(",")) {
                if (id.length() <= 0) continue;
                memberGroupIDs.add(Integer.valueOf(id));
            }
        }
        String memberEPeopleIDsString = this.parameters.getParameter("memberEPeopleIDs", null);
        ArrayList<Integer> memberEPeopleIDs = new ArrayList<Integer>();
        if (memberEPeopleIDsString != null) {
            for (String id : memberEPeopleIDsString.split(",")) {
                if (id.length() <= 0) continue;
                memberEPeopleIDs.add(Integer.valueOf(id));
            }
        }
        int highlightEPersonID = this.parameters.getParameterAsInteger("highlightEPersonID", -1);
        int highlightGroupID = this.parameters.getParameterAsInteger("highlightGroupID", -1);
        String query = EditGroupForm.decodeFromURL(this.parameters.getParameter("query", null));
        int page = this.parameters.getParameterAsInteger("page", 0);
        String type = this.parameters.getParameter("type", null);
        String errorString = this.parameters.getParameter("errors", null);
        ArrayList<String> errors = new ArrayList<String>();
        if (errorString != null) {
            for (String error : errorString.split(",")) {
                errors.add(error);
            }
        }
        Division main = body.addInteractiveDivision("group-edit", this.contextPath + "/admin/groups", "post", "primary administrative groups");
        if (group == null) {
            main.setHead(T_main_head_new);
        } else {
            main.setHead(T_main_head.parameterize(group.getName(), groupID));
        }
        if (collection != null) {
            Para para = main.addPara();
            para.addContent(T_collection_para);
            para.addXref(this.contextPath + "/handle/" + collection.getHandle(), collection.getMetadata("name"));
        } else if (community != null) {
            Para para = main.addPara();
            para.addContent(T_community_para);
            para.addXref(this.contextPath + "/handle/" + community.getHandle(), community.getMetadata("name"));
        }
        Division actions = main.addDivision("group-edit-actions");
        Para groupName = actions.addPara();
        groupName.addContent(T_label_name);
        Text groupText = groupName.addText("group_name");
        groupText.setValue(currentName);
        if (collection != null || community != null) {
            groupText.setDisabled();
            groupText.setHelp(T_label_instructions);
        } else if (errors.contains("group_name") || errors.contains("group_name_duplicate")) {
            groupText.addError("");
        }
        Para searchBoxes = actions.addPara();
        searchBoxes.addContent(T_label_search);
        Text queryField = searchBoxes.addText("query");
        queryField.setValue(query);
        queryField.setSize(15);
        searchBoxes.addButton("submit_search_epeople").setValue(T_submit_search_people);
        searchBoxes.addButton("submit_search_groups").setValue(T_submit_search_groups);
        if (query != null) {
            if ("eperson".equals(type)) {
                searchBoxes.addButton("submit_clear").setValue(T_submit_clear);
                this.addEPeopleSearch(main, query, page, group, memberEPeopleIDs);
            } else if ("group".equals(type)) {
                searchBoxes.addButton("submit_clear").setValue(T_submit_clear);
                this.addGroupSearch(main, group, query, page, group, memberGroupIDs);
            }
        }
        boolean changes = false;
        if (group != null) {
            changes = this.addMemberList(main, group, memberGroupIDs, memberEPeopleIDs, highlightEPersonID, highlightGroupID);
        }
        Para buttons = main.addPara();
        buttons.addButton("submit_save").setValue(T_submit_save);
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
        if (changes) {
            main.addPara().addHighlight("warn").addContent(T_pending_warn);
        }
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private void addEPeopleSearch(Division div, String query, int page, Group group, List<Integer> memberEPeopleIDs) throws SQLException, WingException {
        int resultCount = EPerson.searchResultCount((Context)this.context, (String)query);
        EPerson[] epeople = EPerson.search((Context)this.context, (String)query, (int)(page * 5), (int)5);
        Division results = div.addDivision("results");
        if (resultCount > 5) {
            String baseURL = this.contextPath + "/admin/groups?administrative-continue=" + this.knot.getId();
            int firstIndex = page * 5 + 1;
            int lastIndex = page * 5 + epeople.length;
            String nextURL = null;
            String prevURL = null;
            if (page < resultCount / 5) {
                nextURL = baseURL + "&page=" + (page + 1);
            }
            if (page > 0) {
                prevURL = baseURL + "&page=" + (page - 1);
            }
            results.setSimplePagination(resultCount, firstIndex, lastIndex, prevURL, nextURL);
        }
        Table table = results.addTable("group-edit-search-eperson", epeople.length + 1, 1);
        Row header = table.addRow("header");
        header.addCell().addContent(T_epeople_column1);
        header.addCell().addContent(T_epeople_column2);
        header.addCell().addContent(T_epeople_column3);
        header.addCell().addContent(T_epeople_column4);
        for (EPerson person : epeople) {
            String epersonID = String.valueOf(person.getID());
            String fullName = person.getFullName();
            String email = person.getEmail();
            String url = this.contextPath + "/admin/epeople?administrative-continue=" + this.knot.getId() + "&submit_edit_eperson&epersonID=" + epersonID;
            Row personData = table.addRow();
            personData.addCell().addContent(person.getID());
            personData.addCell().addXref(url, fullName);
            personData.addCell().addXref(url, email);
            if (memberEPeopleIDs.contains(person.getID())) {
                if (group != null && group.isMember(person)) {
                    personData.addCellContent(T_member);
                    continue;
                }
                personData.addCell().addHighlight("warn").addContent(T_pending);
                continue;
            }
            personData.addCell().addButton("submit_add_eperson_" + epersonID).setValue(T_submit_add);
        }
        if (epeople.length <= 0) {
            table.addRow().addCell(1, 4).addContent(T_no_results);
        }
    }

    private void addGroupSearch(Division div, Group sourceGroup, String query, int page, Group parent, List<Integer> memberGroupIDs) throws WingException, SQLException {
        int resultCount = Group.searchResultCount((Context)this.context, (String)query);
        Group[] groups = Group.search((Context)this.context, (String)query, (int)(page * 5), (int)5);
        Division results = div.addDivision("results");
        if (resultCount > 5) {
            String baseURL = this.contextPath + "/admin/groups?administrative-continue=" + this.knot.getId();
            int firstIndex = page * 5 + 1;
            int lastIndex = page * 5 + groups.length;
            String nextURL = null;
            String prevURL = null;
            if (page < resultCount / 5) {
                nextURL = baseURL + "&page=" + (page + 1);
            }
            if (page > 0) {
                prevURL = baseURL + "&page=" + (page - 1);
            }
            results.setSimplePagination(resultCount, firstIndex, lastIndex, prevURL, nextURL);
        }
        Table table = results.addTable("roup-edit-search-group", groups.length + 1, 1);
        Row header = table.addRow("header");
        header.addCell().addContent(T_groups_column1);
        header.addCell().addContent(T_groups_column2);
        header.addCell().addContent(T_groups_column3);
        header.addCell().addContent(T_groups_column4);
        header.addCell().addContent(T_groups_column5);
        for (Group group : groups) {
            Collection collection;
            String groupID = String.valueOf(group.getID());
            String name = group.getName();
            String url = this.contextPath + "/admin/groups?administrative-continue=" + this.knot.getId() + "&submit_edit_group&groupID=" + groupID;
            int memberCount = group.getMembers().length + group.getMemberGroups().length;
            Row row = table.addRow();
            row.addCell().addContent(groupID);
            if (AuthorizeManager.isAdmin((Context)this.context)) {
                row.addCell().addXref(url, name);
            } else {
                row.addCell().addContent(name);
            }
            row.addCell().addContent(memberCount == 0 ? "-" : String.valueOf(memberCount));
            Cell cell = row.addCell();
            if (FlowGroupUtils.getCollectionId(group.getName()) > -1 && (collection = Collection.find((Context)this.context, (int)FlowGroupUtils.getCollectionId(group.getName()))) != null) {
                String collectionName = collection.getMetadata("name");
                if (collectionName == null) {
                    collectionName = "";
                } else if (collectionName.length() > 25) {
                    collectionName = collectionName.substring(0, 22) + "...";
                }
                cell.addContent(collectionName + " ");
                Highlight highlight = cell.addHighlight("fade");
                highlight.addContent("[");
                highlight.addXref(this.contextPath + "/handle/" + collection.getHandle(), T_groups_collection_link);
                highlight.addContent("]");
            }
            if (memberGroupIDs.contains(group.getID())) {
                if (parent != null && parent.isMember(group)) {
                    row.addCellContent(T_member);
                    continue;
                }
                row.addCell().addHighlight("warn").addContent(T_pending);
                continue;
            }
            if (this.isDescendant(sourceGroup, group, memberGroupIDs)) {
                row.addCellContent(T_cycle);
                continue;
            }
            row.addCell().addButton("submit_add_group_" + groupID).setValue(T_submit_add);
        }
        if (groups.length <= 0) {
            table.addRow().addCell(1, 4).addContent(T_no_results);
        }
    }

    private boolean isDescendant(Group descendant, Group ancestor, List<Integer> memberGroupIDs) throws SQLException {
        LinkedList<Group> toVisit = new LinkedList<Group>();
        toVisit.offer(ancestor);
        for (Integer groupid : memberGroupIDs) {
            Group member = Group.find((Context)this.context, (int)groupid);
            toVisit.offer(member);
        }
        while (!toVisit.isEmpty()) {
            Group currentGroup = (Group)toVisit.poll();
            if (currentGroup.equals((Object)descendant)) {
                return true;
            }
            for (Group nextBatch : currentGroup.getMemberGroups()) {
                toVisit.offer(nextBatch);
            }
        }
        return false;
    }

    private boolean addMemberList(Division div, Group parent, List<Integer> memberGroupIDs, List<Integer> memberEPeopleIDs, int highlightEPersonID, int highlightGroupID) throws WingException, SQLException {
        boolean changes = false;
        Division members = div.addDivision("group-edit-members");
        members.setHead(T_members_head);
        Table table = members.addTable("group-edit-members-table", memberGroupIDs.size() + memberEPeopleIDs.size() + 1, 4);
        Row header = table.addRow("header");
        header.addCell().addContent(T_members_column1);
        header.addCell().addContent(T_members_column2);
        header.addCell().addContent(T_members_column3);
        header.addCell().addContent(T_members_column4);
        ArrayList<Integer> allMemberGroupIDs = new ArrayList<Integer>(memberGroupIDs);
        for (Group group : parent.getMemberGroups()) {
            if (allMemberGroupIDs.contains(group.getID())) continue;
            allMemberGroupIDs.add(group.getID());
        }
        Collections.sort(allMemberGroupIDs);
        for (Integer groupID : allMemberGroupIDs) {
            Group group = Group.find((Context)this.context, (int)groupID);
            boolean highlight = group.getID() == highlightGroupID;
            boolean pendingAddition = !parent.isMember(group);
            boolean pendingRemoval = !memberGroupIDs.contains(groupID);
            this.addMemberRow(table, group, highlight, pendingAddition, pendingRemoval);
            if (!pendingAddition && !pendingRemoval) continue;
            changes = true;
        }
        ArrayList<Integer> allMemberEPeopleIDs = new ArrayList<Integer>(memberEPeopleIDs);
        for (EPerson eperson : parent.getMembers()) {
            if (allMemberEPeopleIDs.contains(eperson.getID())) continue;
            allMemberEPeopleIDs.add(eperson.getID());
        }
        Collections.sort(allMemberEPeopleIDs);
        for (Integer epersonID : allMemberEPeopleIDs) {
            EPerson eperson = EPerson.find((Context)this.context, (int)epersonID);
            boolean highlight = eperson.getID() == highlightEPersonID;
            boolean pendingAddition = !parent.isMember(eperson);
            boolean pendingRemoval = !memberEPeopleIDs.contains(epersonID);
            this.addMemberRow(table, eperson, highlight, pendingAddition, pendingRemoval);
            if (!pendingAddition && !pendingRemoval) continue;
            changes = true;
        }
        if (allMemberGroupIDs.size() <= 0 && allMemberEPeopleIDs.size() <= 0) {
            table.addRow().addCell(1, 4).addContent(T_members_none);
        }
        return changes;
    }

    private void addMemberRow(Table table, Group group, boolean highlight, boolean pendingAddition, boolean pendingRemoval) throws WingException, SQLException {
        String name = group.getName();
        String url = this.contextPath + "/admin/groups?administrative-continue=" + this.knot.getId() + "&submit_edit_group&groupID=" + group.getID();
        Row groupData = table.addRow(null, null, highlight ? "highlight" : null);
        groupData.addCell().addHighlight("bold").addContent(group.getID());
        Cell nameCell = groupData.addCell();
        if (AuthorizeManager.isAdmin((Context)this.context)) {
            nameCell.addHighlight("bold").addXref(url, T_members_group_name.parameterize(name));
        } else {
            nameCell.addHighlight("bold").addContent(T_members_group_name.parameterize(name));
        }
        if (pendingAddition) {
            nameCell.addContent(" ");
            nameCell.addHighlight("warn").addContent(T_members_pending);
        }
        groupData.addCell().addContent("-");
        if (pendingRemoval) {
            groupData.addCell().addHighlight("warn").addContent(T_pending);
        } else {
            groupData.addCell().addButton("submit_remove_group_" + group.getID()).setValue(T_submit_remove);
        }
    }

    private void addMemberRow(Table table, EPerson eperson, boolean highlight, boolean pendingAddition, boolean pendingRemoval) throws WingException, SQLException {
        String fullName = eperson.getFullName();
        String email = eperson.getEmail();
        String url = this.contextPath + "/admin/epeople?administrative-continue=" + this.knot.getId() + "&submit_edit_eperson&epersonID=" + eperson.getID();
        Row personData = table.addRow(null, null, highlight ? "highlight" : null);
        personData.addCell().addContent(eperson.getID());
        Cell nameCell = personData.addCell();
        nameCell.addXref(url, fullName);
        if (pendingAddition) {
            nameCell.addContent(" ");
            nameCell.addHighlight("warn").addContent(T_members_pending);
        }
        personData.addCell().addXref(url, email);
        if (pendingRemoval) {
            personData.addCell().addHighlight("warn").addContent(T_pending);
        } else {
            personData.addCell().addButton("submit_remove_eperson_" + eperson.getID()).setValue(T_submit_remove);
        }
    }
}

