/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

public class Contact
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_title = Contact.message("xmlui.ArtifactBrowser.Contact.title");
    private static final Message T_dspace_home = Contact.message("xmlui.general.dspace_home");
    private static final Message T_trail = Contact.message("xmlui.ArtifactBrowser.Contact.trail");
    private static final Message T_head = Contact.message("xmlui.ArtifactBrowser.Contact.head");
    private static final Message T_para1 = Contact.message("xmlui.ArtifactBrowser.Contact.para1");
    private static final Message T_feedback_label = Contact.message("xmlui.ArtifactBrowser.Contact.feedback_label");
    private static final Message T_feedback_link = Contact.message("xmlui.ArtifactBrowser.Contact.feedback_link");
    private static final Message T_email = Contact.message("xmlui.ArtifactBrowser.Contact.email");

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Division contact = body.addDivision("contact", "primary");
        contact.setHead(T_head);
        String name = ConfigurationManager.getProperty((String)"dspace.name");
        contact.addPara(T_para1.parameterize(name));
        List list = contact.addList("contact");
        list.addLabel(T_feedback_label);
        list.addItem().addXref(this.contextPath + "/feedback", T_feedback_link);
        list.addLabel(T_email);
        String email = ConfigurationManager.getProperty((String)"feedback.recipient");
        list.addItem().addXref("mailto:" + email, email);
    }
}

