/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.statistics.Report;
import org.dspace.app.statistics.ReportGenerator;
import org.dspace.app.statistics.ReportTools;
import org.dspace.app.statistics.Stat;
import org.dspace.app.statistics.Statistics;
import org.dspace.app.statistics.StatisticsLoader;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class StatisticsViewer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(StatisticsViewer.class);
    private static final Message T_dspace_home = StatisticsViewer.message("xmlui.general.dspace_home");
    private static final Message T_choose_report = StatisticsViewer.message("xmlui.ArtifactBrowser.StatisticsViewer.choose_month");
    private static final Message T_page_title = StatisticsViewer.message("xmlui.ArtifactBrowser.StatisticsViewer.report.title");
    private static final Message T_empty_title = StatisticsViewer.message("xmlui.ArtifactBrowser.StatisticsViewer.no_report.title");
    private static final Message T_empty_text = StatisticsViewer.message("xmlui.ArtifactBrowser.StatisticsViewer.no_report.text");
    private static final SimpleDateFormat sdfDisplay = new SimpleDateFormat("MM'/'yyyy");
    private static final SimpleDateFormat sdfLink = new SimpleDateFormat("yyyy'-'M");
    private boolean initialised = false;
    private String reportDate = null;
    private SourceValidity validity;
    private static final int MAX_ENTRY_LENGTH = 50;
    private static final int MAX_LABEL_LENGTH = 100;

    public Serializable getKey() {
        this.initialise();
        if (this.reportDate != null) {
            return this.reportDate;
        }
        return "general";
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                this.initialise();
                boolean showReport = ConfigurationManager.getBooleanProperty((String)"report.public");
                if (!showReport) {
                    try {
                        showReport = AuthorizeManager.isAdmin((Context)this.context);
                    }
                    catch (SQLException sqle) {
                        log.error((Object)"Unable to check for administrator", (Throwable)sqle);
                    }
                }
                if (showReport) {
                    File analysisFile = null;
                    analysisFile = this.reportDate != null ? StatisticsLoader.getAnalysisFor((String)this.reportDate) : StatisticsLoader.getGeneralAnalysis();
                    if (analysisFile != null) {
                        DSpaceValidity newValidity = new DSpaceValidity();
                        newValidity.add(Long.toString(analysisFile.lastModified()));
                        newValidity.add("-");
                        newValidity.add(Long.toString(analysisFile.length()));
                        this.validity = newValidity.complete();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    @Override
    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Date[] monthlyDates = StatisticsLoader.getMonthlyAnalysisDates();
        if (monthlyDates != null && monthlyDates.length > 0) {
            org.dspace.app.xmlui.wing.element.List statList = options.addList("statsreports");
            statList.setHead(T_choose_report);
            HashMap<String, String> params = new HashMap<String, String>();
            for (Date date : monthlyDates) {
                params.put("date", sdfLink.format(date));
                statList.addItemXref(AbstractDSpaceTransformer.generateURL("statistics", params), sdfDisplay.format(date));
            }
        }
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.initialise();
        pageMeta.addMetadata("title").addContent(T_page_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_page_title);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.initialise();
        boolean publicise = ConfigurationManager.getBooleanProperty((String)"report.public");
        if (!publicise && !AuthorizeManager.isAdmin((Context)this.context)) {
            throw new AuthorizeException();
        }
        File analysisFile = this.reportDate != null ? StatisticsLoader.getAnalysisFor((String)this.reportDate) : StatisticsLoader.getGeneralAnalysis();
        Division div = body.addDivision("statistics", "primary");
        if (analysisFile != null) {
            try {
                XMLUIReport myRep = new XMLUIReport(div);
                ReportGenerator.processReport((Context)this.context, (Report)myRep, (String)analysisFile.getCanonicalPath());
            }
            catch (Exception e) {
                throw new UIException(e);
            }
        } else {
            div.setHead(T_empty_title);
            div.addPara(T_empty_text);
        }
    }

    private void initialise() {
        if (!this.initialised) {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            this.reportDate = request.getParameter("date");
            this.initialised = true;
        }
    }

    @Override
    public void recycle() {
        this.initialised = false;
        this.reportDate = null;
        this.validity = null;
        super.recycle();
    }

    private static String entry(String entry) {
        if (entry != null && entry.length() > 50) {
            entry = entry.substring(0, 47) + "...";
        }
        return entry;
    }

    private static String label(String label) {
        if (label != null && label.length() > 100) {
            label = label.substring(0, 97) + "...";
        }
        return label;
    }

    static class XMLUIReport
    implements Report {
        private List<Statistics> blocks = new ArrayList<Statistics>();
        private String mainTitle = null;
        private String pageTitle = null;
        private Date start = null;
        private Date end = null;
        private Division rootDiv;
        private Division currDiv;

        private XMLUIReport() {
        }

        public XMLUIReport(Division myDiv) {
            this.rootDiv = myDiv;
            this.currDiv = myDiv;
        }

        public String header() {
            return this.header("");
        }

        public String header(String title) {
            return "";
        }

        public String mainTitle() {
            try {
                this.rootDiv.setHead(this.mainTitle);
            }
            catch (WingException we) {
                log.error((Object)"Error creating XML for report", (Throwable)we);
            }
            return null;
        }

        public String dateRange() {
            StringBuilder content = new StringBuilder();
            DateFormat df = DateFormat.getDateInstance();
            if (this.start != null) {
                content.append(df.format(this.start));
            } else {
                content.append("from start of records ");
            }
            content.append(" to ");
            if (this.end != null) {
                content.append(df.format(this.end));
            } else {
                content.append(" end of records");
            }
            try {
                this.rootDiv.addDivision("reportDate").addPara(content.toString());
            }
            catch (WingException we) {
                log.error((Object)"Error creating XML for report", (Throwable)we);
            }
            return null;
        }

        public String sectionHeader(String title) {
            try {
                this.currDiv.setHead(title);
            }
            catch (WingException we) {
                log.error((Object)"Error creating XML for report", (Throwable)we);
            }
            return null;
        }

        public String statBlock(Statistics content) {
            Stat[] stats = content.getStats();
            try {
                int rows = stats.length;
                if (content.getStatName() != null || content.getResultName() != null) {
                    ++rows;
                }
                Table block = this.currDiv.addTable("reportBlock", rows, 2, "detailtable");
                if (content.getStatName() != null || content.getResultName() != null) {
                    Row row = block.addRow();
                    if (content.getStatName() != null) {
                        row.addCellContent(content.getStatName());
                    } else {
                        row.addCellContent("&nbsp;");
                    }
                    if (content.getResultName() != null) {
                        row.addCellContent(content.getResultName());
                    } else {
                        row.addCellContent("&nbsp;");
                    }
                }
                for (int i = 0; i < stats.length; ++i) {
                    Row row = block.addRow();
                    if (stats[i].getReference() != null) {
                        row.addCell().addXref(stats[i].getReference()).addContent(StatisticsViewer.label(stats[i].getKey()));
                    } else {
                        row.addCell().addContent(StatisticsViewer.label(stats[i].getKey()));
                    }
                    if (stats[i].getUnits() != null) {
                        row.addCell(null, null, "right").addContent(StatisticsViewer.entry(stats[i].getValue() + " " + stats[i].getUnits()));
                        continue;
                    }
                    row.addCell(null, null, "right").addContent(StatisticsViewer.entry(ReportTools.numberFormat((int)stats[i].getValue())));
                }
            }
            catch (WingException we) {
                log.error((Object)"Error creating XML for report", (Throwable)we);
            }
            return null;
        }

        public String floorInfo(int floor) {
            try {
                if (floor > 0) {
                    this.currDiv.addDivision("reportFloor").addPara("(more than " + ReportTools.numberFormat((int)floor) + " times)");
                }
            }
            catch (WingException we) {
                log.error((Object)"Error creating XML for report", (Throwable)we);
            }
            return null;
        }

        public String blockExplanation(String explanation) {
            try {
                if (explanation != null) {
                    this.currDiv.addDivision("reportExplanation").addPara(explanation);
                }
            }
            catch (WingException we) {
                log.error((Object)"Error creating XML for report", (Throwable)we);
            }
            return null;
        }

        public String footer() {
            return "";
        }

        public void setMainTitle(String name, String serverName) {
            this.mainTitle = "Statistics for " + name;
            if (ConfigurationManager.getBooleanProperty((String)"report.show.server", (boolean)true)) {
                this.mainTitle = this.mainTitle + " on " + serverName;
            }
            if (this.pageTitle == null) {
                this.pageTitle = this.mainTitle;
            }
        }

        public void addBlock(Statistics stat) {
            this.blocks.add(stat);
        }

        public String render() {
            Pattern space = Pattern.compile(" ");
            this.header(this.pageTitle);
            this.mainTitle();
            this.dateRange();
            for (Statistics stats : this.blocks) {
                try {
                    String title = stats.getSectionHeader();
                    String aName = title.toLowerCase();
                    Matcher matchSpace = space.matcher(aName);
                    aName = matchSpace.replaceAll("_");
                    this.currDiv = this.rootDiv.addDivision(aName);
                    this.sectionHeader(title);
                    this.blockExplanation(stats.getExplanation());
                    this.floorInfo(stats.getFloor());
                    this.statBlock(stats);
                    this.currDiv = this.rootDiv;
                }
                catch (WingException we) {
                    log.error((Object)"Error creating XML for report", (Throwable)we);
                }
            }
            return null;
        }

        public void setStartDate(Date start) {
            this.start = start;
        }

        public void setEndDate(Date end) {
            this.end = end;
        }
    }
}

