/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.browseArtifacts;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.cocoon.ProcessingException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.xml.sax.SAXException;

public class CollectionBrowse
extends AbstractDSpaceTransformer {
    private static final Message T_head_browse = CollectionBrowse.message("xmlui.ArtifactBrowser.CollectionViewer.head_browse");
    private static final Message T_browse_titles = CollectionBrowse.message("xmlui.ArtifactBrowser.CollectionViewer.browse_titles");
    private static final Message T_browse_authors = CollectionBrowse.message("xmlui.ArtifactBrowser.CollectionViewer.browse_authors");
    private static final Message T_browse_dates = CollectionBrowse.message("xmlui.ArtifactBrowser.CollectionViewer.browse_dates");

    @Override
    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException, ProcessingException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (!(dso instanceof Collection)) {
            return;
        }
        Collection collection = (Collection)dso;
        Division home = body.addDivision("collection-home", "primary repository collection");
        Division search = home.addDivision("collection-search-browse", "secondary search-browse");
        Division browseDiv = search.addDivision("collection-browse", "secondary browse");
        List browse = browseDiv.addList("collection-browse", "simple", "collection-browse");
        browse.setHead(T_head_browse);
        String url = this.contextPath + "/handle/" + collection.getHandle();
        try {
            BrowseIndex[] bis;
            for (BrowseIndex bix : bis = BrowseIndex.getBrowseIndices()) {
                HashMap<String, String> queryParams = new HashMap<String, String>();
                queryParams.put("type", bix.getName());
                browse.addItemXref(CollectionBrowse.generateURL(url + "/browse", queryParams), CollectionBrowse.message("xmlui.ArtifactBrowser.Navigation.browse_" + bix.getName()));
            }
        }
        catch (BrowseException bex) {
            browse.addItemXref(url + "/browse?type=title", T_browse_titles);
            browse.addItemXref(url + "/browse?type=author", T_browse_authors);
            browse.addItemXref(url + "/browse?type=dateissued", T_browse_dates);
        }
    }
}

