/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.aspect.discovery.AbstractSearch;
import org.dspace.app.xmlui.aspect.discovery.DiscoveryUIUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.utils.DSpace;
import org.xml.sax.SAXException;

public class SimpleSearch
extends AbstractSearch
implements CacheableProcessingComponent {
    private static final Message T_title = SimpleSearch.message("xmlui.ArtifactBrowser.SimpleSearch.title");
    private static final Message T_dspace_home = SimpleSearch.message("xmlui.general.dspace_home");
    private static final Message T_trail = SimpleSearch.message("xmlui.ArtifactBrowser.SimpleSearch.trail");
    private static final Message T_search_scope = SimpleSearch.message("xmlui.Discovery.SimpleSearch.search_scope");
    private static final Message T_head = SimpleSearch.message("xmlui.ArtifactBrowser.SimpleSearch.head");
    private static final Message T_go = SimpleSearch.message("xmlui.general.go");
    private static final Message T_filter_label = SimpleSearch.message("xmlui.Discovery.SimpleSearch.filter_head");
    private static final Message T_filter_help = SimpleSearch.message("xmlui.Discovery.SimpleSearch.filter_help");
    private static final Message T_filter_current_filters = SimpleSearch.message("xmlui.Discovery.AbstractSearch.filters.controls.current-filters.head");
    private static final Message T_filter_new_filters = SimpleSearch.message("xmlui.Discovery.AbstractSearch.filters.controls.new-filters.head");
    private static final Message T_filter_controls_apply = SimpleSearch.message("xmlui.Discovery.AbstractSearch.filters.controls.apply-filters");
    private static final Message T_filter_controls_add = SimpleSearch.message("xmlui.Discovery.AbstractSearch.filters.controls.add-filter");
    private static final Message T_filter_controls_remove = SimpleSearch.message("xmlui.Discovery.AbstractSearch.filters.controls.remove-filter");
    private static final Message T_filters_show = SimpleSearch.message("xmlui.Discovery.AbstractSearch.filters.display");
    private static final Message T_filter_contain = SimpleSearch.message("xmlui.Discovery.SimpleSearch.filter.contains");
    private static final Message T_filter_equals = SimpleSearch.message("xmlui.Discovery.SimpleSearch.filter.equals");
    private static final Message T_filter_notcontain = SimpleSearch.message("xmlui.Discovery.SimpleSearch.filter.notcontains");
    private static final Message T_filter_notequals = SimpleSearch.message("xmlui.Discovery.SimpleSearch.filter.notequals");
    private static final Message T_filter_authority = SimpleSearch.message("xmlui.Discovery.SimpleSearch.filter.authority");
    private static final Message T_filter_notauthority = SimpleSearch.message("xmlui.Discovery.SimpleSearch.filter.notauthority");
    private static final Message T_did_you_mean = SimpleSearch.message("xmlui.Discovery.SimpleSearch.did_you_mean");
    private SearchService searchService = null;

    public SimpleSearch() {
        DSpace dspace = new DSpace();
        this.searchService = (SearchService)dspace.getServiceManager().getServiceByName(SearchService.class.getName(), SearchService.class);
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException, SQLException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (dso instanceof Collection || dso instanceof Community) {
            HandleUtil.buildHandleTrail(dso, pageMeta, this.contextPath, true);
        }
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String queryString = this.getQuery();
        Division search = body.addDivision("search", "primary");
        search.setHead(T_head);
        String searchUrl = ConfigurationManager.getProperty((String)"dspace.url") + "/JSON/discovery/search";
        search.addHidden("discovery-json-search-url").setValue(searchUrl);
        DSpaceObject currentScope = this.getScope();
        if (currentScope != null) {
            search.addHidden("discovery-json-scope").setValue(currentScope.getHandle());
        }
        search.addHidden("contextpath").setValue(this.contextPath);
        Map<String, String[]> fqs = this.getParameterFilterQueries();
        Division searchBoxDivision = search.addDivision("discovery-search-box", "discoverySearchBox");
        Division mainSearchDiv = searchBoxDivision.addInteractiveDivision("general-query", "discover", "get", "discover-search-box");
        org.dspace.app.xmlui.wing.element.List searchList = mainSearchDiv.addList("primary-search", "form");
        if (this.variableScope()) {
            Select scope = searchList.addItem().addSelect("scope");
            scope.setLabel(T_search_scope);
            this.buildScopeList(scope);
        }
        Item searchBoxItem = searchList.addItem();
        Text text = searchBoxItem.addText("query");
        text.setValue(queryString);
        searchBoxItem.addButton("submit", "search-icon").setValue(T_go);
        if (this.queryResults != null && StringUtils.isNotBlank((String)this.queryResults.getSpellCheckQuery())) {
            Item didYouMeanItem = searchList.addItem("did-you-mean", "didYouMean");
            didYouMeanItem.addContent(T_did_you_mean);
            didYouMeanItem.addXref(this.getSuggestUrl(this.queryResults.getSpellCheckQuery()), this.queryResults.getSpellCheckQuery(), "didYouMean");
        }
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)dso);
        List filterFields = discoveryConfiguration.getSearchFilters();
        List<String> filterTypes = DiscoveryUIUtils.getRepeatableParameters(request, "filtertype");
        List<String> filterOperators = DiscoveryUIUtils.getRepeatableParameters(request, "filter_relational_operator");
        List<String> filterValues = DiscoveryUIUtils.getRepeatableParameters(request, "filter");
        if (0 < filterFields.size() && filterTypes.size() == 0) {
            searchList.addItem().addXref("display-filters", T_filters_show);
        }
        this.addHiddenFormFields("search", request, fqs, mainSearchDiv);
        if (0 < filterFields.size()) {
            Division searchFiltersDiv = searchBoxDivision.addInteractiveDivision("search-filters", "discover", "get", "discover-filters-box " + (0 < filterTypes.size() ? "" : "hidden"));
            Division filtersWrapper = searchFiltersDiv.addDivision("discovery-filters-wrapper");
            filtersWrapper.setHead(T_filter_label);
            filtersWrapper.addPara(T_filter_help);
            Table filtersTable = filtersWrapper.addTable("discovery-filters", 1, 4, "discovery-filters");
            if (filterTypes.size() > 0) {
                filtersTable.addRow("header").addCell("", "header", 1, 4, "new-filter-header").addContent(T_filter_current_filters);
                for (int i = 0; i < filterTypes.size(); ++i) {
                    String filterType = filterTypes.get(i);
                    String filterValue = filterValues.get(i);
                    String filterOperator = filterOperators.get(i);
                    if (!StringUtils.isNotBlank((String)filterValue)) continue;
                    Row row = filtersTable.addRow("used-filters-" + i + 1, "data", "search-filter used-filter");
                    this.addFilterRow(filterFields, i + 1, row, filterType, filterOperator, filterValue);
                }
                filtersTable.addRow("filler-row", "data", "search-filter filler").addCell(1, 4).addContent("");
                filtersTable.addRow("header").addCell("", "header", 1, 4, "new-filter-header").addContent(T_filter_new_filters);
            }
            int index = filterTypes.size() + 1;
            Row row = filtersTable.addRow("filter-new-" + index, "data", "search-filter");
            this.addFilterRow(filterFields, index, row, null, null, null);
            Row filterControlsItem = filtersTable.addRow("filter-controls", "data", "apply-filter");
            filterControlsItem.addCell(1, 4).addButton("submit_apply_filter", "discovery-apply-filter-button").setValue(T_filter_controls_apply);
            this.addHiddenFormFields("filter", request, fqs, searchFiltersDiv);
        }
        this.buildMainForm(search);
        try {
            this.buildSearchResultsDivision(search);
        }
        catch (SearchServiceException e) {
            throw new UIException(e.getMessage(), e);
        }
    }

    protected void addFilterRow(List<DiscoverySearchFilter> filterFields, int index, Row row, String selectedFilterType, String relationalOperator, String value) throws WingException {
        Select select = row.addCell("", "data", "selection").addSelect("filtertype_" + index);
        for (DiscoverySearchFilter searchFilter : filterFields) {
            select.addOption(StringUtils.equals((String)searchFilter.getIndexFieldName(), (String)selectedFilterType), searchFilter.getIndexFieldName(), SimpleSearch.message("xmlui.ArtifactBrowser.SimpleSearch.filter." + searchFilter.getIndexFieldName()));
        }
        Select typeSelect = row.addCell("", "data", "selection").addSelect("filter_relational_operator_" + index);
        typeSelect.addOption(StringUtils.equals((String)relationalOperator, (String)"contains"), "contains", T_filter_contain);
        typeSelect.addOption(StringUtils.equals((String)relationalOperator, (String)"equals"), "equals", T_filter_equals);
        typeSelect.addOption(StringUtils.equals((String)relationalOperator, (String)"authority"), "authority", T_filter_authority);
        typeSelect.addOption(StringUtils.equals((String)relationalOperator, (String)"notcontains"), "notcontains", T_filter_notcontain);
        typeSelect.addOption(StringUtils.equals((String)relationalOperator, (String)"notequals"), "notequals", T_filter_notequals);
        typeSelect.addOption(StringUtils.equals((String)relationalOperator, (String)"notauthority"), "notauthority", T_filter_notauthority);
        row.addCell("", "data", "discovery-filter-input-cell").addText("filter_" + index, "discovery-filter-input").setValue(value == null ? "" : value);
        Cell buttonsCell = row.addCell("filter-controls_" + index, "data", "filter-controls");
        buttonsCell.addButton("add-filter_" + index, "filter-control filter-add").setValue(T_filter_controls_add);
        buttonsCell.addButton("remove-filter_" + index, "filter-control filter-remove").setValue(T_filter_controls_remove);
    }

    @Override
    protected String getBasicUrl() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        return request.getContextPath() + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/discover";
    }

    @Override
    protected Map<String, String[]> getParameterFilterQueries() {
        return DiscoveryUIUtils.getParameterFilterQueries(ObjectModelHelper.getRequest((Map)this.objectModel));
    }

    @Override
    protected String[] getFilterQueries() {
        return DiscoveryUIUtils.getFilterQueries(ObjectModelHelper.getRequest((Map)this.objectModel), this.context);
    }

    @Override
    protected String getQuery() throws UIException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String query = SimpleSearch.decodeFromURL(request.getParameter("query"));
        if (query == null) {
            return "";
        }
        return query.trim();
    }

    @Override
    protected String generateURL(Map<String, String> parameters) throws UIException {
        String query = this.getQuery();
        if (!"".equals(query) && parameters.get("query") == null) {
            parameters.put("query", SimpleSearch.encodeForURL(query));
        }
        if (parameters.get("page") == null) {
            parameters.put("page", String.valueOf(this.getParameterPage()));
        }
        if (parameters.get("rpp") == null) {
            parameters.put("rpp", String.valueOf(this.getParameterRpp()));
        }
        if (parameters.get("group_by") == null) {
            parameters.put("group_by", String.valueOf(this.getParameterGroup()));
        }
        if (parameters.get("sort_by") == null && this.getParameterSortBy() != null) {
            parameters.put("sort_by", String.valueOf(this.getParameterSortBy()));
        }
        if (parameters.get("order") == null && this.getParameterOrder() != null) {
            parameters.put("order", this.getParameterOrder());
        }
        if (parameters.get("etal") == null) {
            parameters.put("etal", String.valueOf(this.getParameterEtAl()));
        }
        if (parameters.get("scope") == null && this.getParameterScope() != null) {
            parameters.put("scope", this.getParameterScope());
        }
        return AbstractDSpaceTransformer.generateURL("discover", parameters);
    }

    private void addHiddenFormFields(String type, Request request, Map<String, String[]> fqs, Division division) throws WingException {
        if (type.equals("filter") || type.equals("sort")) {
            if (request.getParameter("query") != null) {
                division.addHidden("query").setValue(request.getParameter("query"));
            }
            if (request.getParameter("scope") != null) {
                division.addHidden("scope").setValue(request.getParameter("scope"));
            }
        }
        if (type.equals("search") || type.equals("sort")) {
            for (String parameter : fqs.keySet()) {
                String[] values;
                for (String value : values = fqs.get(parameter)) {
                    division.addHidden(parameter).setValue(value);
                }
            }
        }
        if (type.equals("search") || type.equals("filter")) {
            if (request.getParameter("rpp") != null) {
                division.addHidden("rpp").setValue(request.getParameter("rpp"));
            }
            if (request.getParameter("sort_by") != null) {
                division.addHidden("sort_by").setValue(request.getParameter("sort_by"));
            }
            if (request.getParameter("order") != null) {
                division.addHidden("order").setValue(request.getParameter("order"));
            }
        }
    }

    protected String getSuggestUrl(String newQuery) throws UIException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("query", newQuery);
        return this.addFilterQueriesToUrl(this.generateURL(parameters));
    }
}

