/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.eperson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.aspect.eperson.EPersonUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Password;
import org.xml.sax.SAXException;

public class ResetPassword
extends AbstractDSpaceTransformer {
    private static final Message T_title = ResetPassword.message("xmlui.EPerson.ResetPassword.title");
    private static final Message T_dspace_home = ResetPassword.message("xmlui.general.dspace_home");
    private static final Message T_trail_forgot_password = ResetPassword.message("xmlui.EPerson.trail_forgot_password");
    private static final Message T_head = ResetPassword.message("xmlui.EPerson.ResetPassword.head");
    private static final Message T_para1 = ResetPassword.message("xmlui.EPerson.ResetPassword.para1");
    private static final Message T_email_address = ResetPassword.message("xmlui.EPerson.ResetPassword.email_address");
    private static final Message T_new_password = ResetPassword.message("xmlui.EPerson.ResetPassword.new_password");
    private static final Message T_error_invalid_password = ResetPassword.message("xmlui.EPerson.ResetPassword.error_invalid_password");
    private static final Message T_confirm_password = ResetPassword.message("xmlui.EPerson.ResetPassword.confirm_password");
    private static final Message T_error_unconfirmed_password = ResetPassword.message("xmlui.EPerson.ResetPassword.error_unconfirmed_password");
    private static final Message T_submit = ResetPassword.message("xmlui.EPerson.ResetPassword.submit");
    private String email;
    private List<String> errors;

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.email = parameters.getParameter("email", "unknown");
        String errors = parameters.getParameter("errors", "");
        this.errors = errors.length() > 0 ? Arrays.asList(errors.split(",")) : new ArrayList<String>();
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail_forgot_password);
    }

    @Override
    public void addBody(Body body) throws WingException {
        Division register = body.addInteractiveDivision("reset-password", this.contextPath + "/register", "post", "primary");
        register.setHead(T_head);
        EPersonUtils.forgottProgressList(register, 2);
        register.addPara(T_para1);
        org.dspace.app.xmlui.wing.element.List form = register.addList("form", "form");
        form.addLabel(T_email_address);
        form.addItem(this.email);
        Password password = form.addItem().addPassword("password");
        password.setRequired();
        password.setAutofocus("autofocus");
        password.setLabel(T_new_password);
        if (this.errors.contains("password")) {
            password.addError(T_error_invalid_password);
        }
        Password passwordConfirm = form.addItem().addPassword("password_confirm");
        passwordConfirm.setRequired();
        passwordConfirm.setLabel(T_confirm_password);
        if (this.errors.contains("password_confirm")) {
            passwordConfirm.addError(T_error_unconfirmed_password);
        }
        form.addItem().addButton("submit").setValue(T_submit);
        register.addHidden("eperson-continue").setValue(this.knot.getId());
    }
}

