/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.statistics;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.statistics.Dataset;
import org.dspace.statistics.content.StatisticsTable;
import org.dspace.statistics.content.filter.StatisticsSolrDateFilter;
import org.xml.sax.SAXException;

public abstract class AbstractStatisticsDataTransformer
extends AbstractDSpaceTransformer {
    private static final Message T_time_filter_last_month = AbstractStatisticsDataTransformer.message("xmlui.statistics.StatisticsSearchTransformer.time-filter.last-month");
    private static final Message T_time_filter_overall = AbstractStatisticsDataTransformer.message("xmlui.statistics.StatisticsSearchTransformer.time-filter.overall");
    private static final Message T_time_filter_last_year = AbstractStatisticsDataTransformer.message("xmlui.statistics.StatisticsSearchTransformer.time-filter.last-year");
    private static final Message T_time_filter_last6_months = AbstractStatisticsDataTransformer.message("xmlui.statistics.StatisticsSearchTransformer.time-filter.last-6-months");

    protected void addTimeFilter(Division mainDivision) throws WingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String selectedTimeFilter = request.getParameter("time_filter");
        Select timeFilter = mainDivision.addPara().addSelect("time_filter");
        timeFilter.addOption(StringUtils.equals((String)selectedTimeFilter, (String)"-1"), "-1", T_time_filter_last_month);
        timeFilter.addOption(StringUtils.equals((String)selectedTimeFilter, (String)"-6"), "-6", T_time_filter_last6_months);
        timeFilter.addOption(StringUtils.equals((String)selectedTimeFilter, (String)"-12"), "-12", T_time_filter_last_year);
        timeFilter.addOption(StringUtils.isBlank((String)selectedTimeFilter), "", T_time_filter_overall);
    }

    protected StatisticsSolrDateFilter getDateFilter(String timeFilter) {
        if (StringUtils.isNotEmpty((String)timeFilter)) {
            StatisticsSolrDateFilter dateFilter = new StatisticsSolrDateFilter();
            dateFilter.setStartStr(timeFilter);
            dateFilter.setEndStr("0");
            dateFilter.setTypeStr("month");
            return dateFilter;
        }
        return null;
    }

    protected void addDisplayTable(Division mainDiv, StatisticsTable display, boolean addRowTitles, String[] valueMessagePrefixes) throws SAXException, WingException, SQLException, SolrServerException, IOException, ParseException {
        String title = display.getTitle();
        Dataset dataset = display.getDataset();
        if (dataset == null) {
            dataset = display.getDataset(this.context);
        }
        if (dataset != null) {
            int row;
            String[][] matrix = dataset.getMatrix();
            if (matrix.length == 0) {
                mainDiv.addPara(this.getNoResultsMessage());
                return;
            }
            Division wrapper = mainDiv.addDivision("tablewrapper");
            Table table = wrapper.addTable("list-table", 1, 1, title == null ? "detailtable" : "tableWithTitle detailtable");
            if (title != null) {
                table.setHead(AbstractStatisticsDataTransformer.message(title));
            }
            Row headerRow = table.addRow();
            if (addRowTitles) {
                headerRow.addCell("spacer", "header", "labelcell");
            }
            String[] cLabels = dataset.getColLabels().toArray(new String[0]);
            for (row = 0; row < cLabels.length; ++row) {
                Cell cell = headerRow.addCell("0-" + row + "-h", "header", "labelcell");
                cell.addContent(AbstractStatisticsDataTransformer.message("xmlui.statistics.display.table.column-label." + cLabels[row]));
            }
            for (row = 0; row < matrix.length; ++row) {
                Row valListRow = table.addRow();
                if (addRowTitles) {
                    valListRow.addCell("" + row, "data", "labelcell").addContent((String)dataset.getRowLabels().get(row));
                }
                for (int col = 0; col < matrix[row].length; ++col) {
                    Cell cell = valListRow.addCell(row + "-" + col, "data", "datacell");
                    String messagePrefix = null;
                    if (valueMessagePrefixes != null && col < valueMessagePrefixes.length) {
                        messagePrefix = valueMessagePrefixes[col];
                    }
                    if (messagePrefix != null) {
                        cell.addContent(AbstractStatisticsDataTransformer.message(messagePrefix + matrix[row][col]));
                        continue;
                    }
                    cell.addContent(matrix[row][col]);
                }
            }
        }
    }

    protected abstract Message getNoResultsMessage();
}

