/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.statisticsElasticSearch;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Text;

public class ReportGenerator {
    private static Logger log = Logger.getLogger(ReportGenerator.class);
    private static String MINIMUM_DATE = "2008-01-01";
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    static String[] formatStrings = new String[]{"MM/dd/yyyy", "yyyy-MM-dd"};
    private Map<String, String> params;
    private Date dateStart;
    private Date dateEnd;

    public Date getDateStart() {
        return this.dateStart;
    }

    public String getDateStartFormated() {
        try {
            return dateFormat.format(this.dateStart);
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setDateStart() {
        this.dateStart = !this.params.containsKey("from") ? null : this.tryParse(this.params.get("from"));
    }

    public Date tryParse(String dateString) {
        if (dateString == null || dateString.length() == 0) {
            return null;
        }
        for (String formatString : formatStrings) {
            try {
                return new SimpleDateFormat(formatString).parse(dateString);
            }
            catch (ParseException e) {
                log.error((Object)("ReportGenerator couldn't parse date: " + dateString + ", with pattern of: " + formatString + " with error message:" + e.getMessage()));
            }
        }
        return null;
    }

    public Date getDateEnd() {
        return this.dateEnd;
    }

    public String getDateEndFormatted() {
        try {
            return dateFormat.format(this.dateEnd);
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setDateEnd() {
        this.dateEnd = !this.params.containsKey("to") ? null : this.tryParse(this.params.get("to"));
    }

    public void addReportGeneratorForm(Division parentDivision, Request request) {
        try {
            Division division = parentDivision.addDivision("report-generator", "primary");
            division.setHead("Report Generator");
            division.addPara("Used to generate reports with an arbitrary date range.");
            Division search = parentDivision.addInteractiveDivision("choose-report", request.getRequestURI(), "get", "primary");
            this.params = new HashMap<String, String>();
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String param = (String)paramNames.nextElement();
                this.params.put(param, request.getParameter(param));
            }
            Para reportForm = search.addPara();
            this.setDateStart();
            Text from = reportForm.addText("from", "slick");
            from.setLabel("From");
            from.setHelp("The start date of the report, ex 01/31/2008");
            from.setValue(this.getDateStartFormated());
            this.setDateEnd();
            Text to = reportForm.addText("to", "slick");
            to.setLabel("To");
            to.setHelp("The end date of the report, ex 12/31/2012");
            to.setValue(this.getDateEndFormatted());
            reportForm.addButton("submit_add").setValue("Generate Report");
        }
        catch (WingException e) {
            log.error((Object)e.getMessage());
        }
    }
}

