/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.xmlui.aspect.submission.FlowUtils;
import org.dspace.app.xmlui.aspect.submission.StepAndPage;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.WorkspaceItem;
import org.dspace.workflow.WorkflowItem;
import org.xml.sax.SAXException;

public abstract class AbstractStep
extends AbstractDSpaceTransformer {
    private static Logger log = Logger.getLogger(AbstractStep.class);
    protected static final Message T_submission_title = AbstractStep.message("xmlui.Submission.general.submission.title");
    protected static final Message T_submission_trail = AbstractStep.message("xmlui.Submission.general.submission.trail");
    protected static final Message T_submission_head = AbstractStep.message("xmlui.Submission.general.submission.head");
    protected static final Message T_previous = AbstractStep.message("xmlui.Submission.general.submission.previous");
    protected static final Message T_save = AbstractStep.message("xmlui.Submission.general.submission.save");
    protected static final Message T_next = AbstractStep.message("xmlui.Submission.general.submission.next");
    protected static final Message T_complete = AbstractStep.message("xmlui.Submission.general.submission.complete");
    protected static final Message T_dspace_home = AbstractStep.message("xmlui.general.dspace_home");
    protected static final Message T_workflow_title = AbstractStep.message("xmlui.Submission.general.workflow.title");
    protected static final Message T_workflow_trail = AbstractStep.message("xmlui.Submission.general.workflow.trail");
    protected static final Message T_workflow_head = AbstractStep.message("xmlui.Submission.general.workflow.head");
    protected static final Message T_showfull = AbstractStep.message("xmlui.Submission.general.showfull");
    protected static final Message T_showsimple = AbstractStep.message("xmlui.Submission.general.showsimple");
    protected static final Message T_default_title = AbstractStep.message("xmlui.Submission.general.default.title");
    protected static final Message T_default_trail = AbstractStep.message("xmlui.Submission.general.default.trail");
    protected static final Message T_initial_questions = AbstractStep.message("xmlui.Submission.general.progress.initial_questions");
    protected static final Message T_describe = AbstractStep.message("xmlui.Submission.general.progress.describe");
    protected static final Message T_upload = AbstractStep.message("xmlui.Submission.general.progress.upload");
    protected static final Message T_review = AbstractStep.message("xmlui.Submission.general.progress.review");
    protected static final Message T_creative_commons = AbstractStep.message("xmlui.Submission.general.progress.creative_commons");
    protected static final Message T_license = AbstractStep.message("xmlui.Submission.general.progress.license");
    protected String id;
    protected SubmissionInfo submissionInfo;
    protected InProgressSubmission submission;
    protected StepAndPage stepAndPage;
    protected String handle;
    protected int errorFlag;
    protected List<String> errorFields;
    protected boolean requireSubmission = false;
    protected boolean requireWorkflow = false;
    protected boolean requireWorkspace = false;
    protected boolean requireStep = false;
    protected boolean requireHandle = false;

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        try {
            this.id = parameters.getParameter("id", null);
            this.stepAndPage = new StepAndPage(parameters.getParameter("step", "-1.-1"));
            log.debug((Object)("AbstractStep.setup:  step is " + parameters.getParameter("step", "]defaulted[")));
            this.handle = parameters.getParameter("handle", null);
            this.errorFlag = Integer.valueOf(parameters.getParameter("error", String.valueOf(0)));
            this.errorFields = this.getErrorFields(parameters);
            if (this.id != null) {
                try {
                    this.submissionInfo = FlowUtils.obtainSubmissionInfo(objectModel, this.id);
                }
                catch (AuthorizeException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new ProcessingException((Exception)((Object)e));
                }
                this.submission = this.submissionInfo.getSubmissionItem();
            }
            if (this.requireSubmission && this.submission == null) {
                throw new ProcessingException("Unable to find submission for id: " + this.id);
            }
            if (this.requireWorkflow && !(this.submission instanceof WorkflowItem)) {
                throw new ProcessingException("The submission is not a workflow, " + this.id);
            }
            if (this.requireWorkspace && !(this.submission instanceof WorkspaceItem)) {
                throw new ProcessingException("The submission is not a workspace, " + this.id);
            }
            if (this.requireStep && this.stepAndPage.getStep() < 0) {
                throw new ProcessingException("Step is a required parameter.");
            }
            if (this.requireHandle && this.handle == null) {
                throw new ProcessingException("Handle is a required parameter.");
            }
        }
        catch (SQLException sqle) {
            throw new ProcessingException("Unable to find submission.", (Throwable)sqle);
        }
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        if (this.submission instanceof WorkspaceItem) {
            pageMeta.addMetadata("title").addContent(T_submission_title);
            Collection collection = this.submission.getCollection();
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
            HandleUtil.buildHandleTrail((DSpaceObject)collection, pageMeta, this.contextPath, true);
            pageMeta.addTrail().addContent(T_submission_trail);
        } else if (this.submissionInfo != null && this.submissionInfo.isInWorkflow()) {
            pageMeta.addMetadata("title").addContent(T_workflow_title);
            Collection collection = this.submission.getCollection();
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
            HandleUtil.buildHandleTrail((DSpaceObject)collection, pageMeta, this.contextPath, true);
            pageMeta.addTrail().addContent(T_workflow_trail);
        } else {
            pageMeta.addMetadata("title").addContent(T_default_title);
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
            pageMeta.addTrail().addContent(T_default_trail);
        }
    }

    public void addSubmissionProgressList(Division div) throws WingException {
        org.dspace.app.xmlui.wing.element.List progress = div.addList("submit-progress", "progress");
        Map progBarInfo = this.submissionInfo.getProgressBarInfo();
        for (Map.Entry progBarEntry : progBarInfo.entrySet()) {
            String entryNameKey = "xmlui.Submission." + (String)progBarEntry.getValue();
            StepAndPage currentStepAndPage = new StepAndPage((String)progBarEntry.getKey());
            this.addJumpButton(progress, AbstractStep.message(entryNameKey), currentStepAndPage);
        }
    }

    public void addJumpButton(org.dspace.app.xmlui.wing.element.List list, Message buttonText, StepAndPage stepAndPage) throws WingException {
        if (buttonText != null && stepAndPage.isSet()) {
            Button jumpButton = list.addItem("step_" + stepAndPage, this.renderJumpButton(stepAndPage)).addButton("submit_jump_" + stepAndPage);
            jumpButton.setValue(buttonText);
        }
    }

    public void addControlButtons(org.dspace.app.xmlui.wing.element.List controls) throws WingException {
        Item actions = controls.addItem();
        if (!this.isFirstStep()) {
            actions.addButton("submit_prev").setValue(T_previous);
        }
        actions.addButton("submit_cancel").setValue(T_save);
        if (this.isLastStep()) {
            actions.addButton("submit_next").setValue(T_complete);
        } else {
            actions.addButton("submit_next").setValue(T_next);
        }
    }

    public int getStep() {
        return this.stepAndPage.getStep();
    }

    public int getPage() {
        return this.stepAndPage.getPage();
    }

    public boolean isFirstStep() {
        Set submissionPagesSet = this.submissionInfo.getProgressBarInfo().keySet();
        String[] submissionPages = submissionPagesSet.toArray(new String[submissionPagesSet.size()]);
        StepAndPage firstStepAndPage = new StepAndPage(submissionPages[0]);
        return firstStepAndPage.equals(this.stepAndPage);
    }

    public boolean isLastStep() {
        boolean inWorkflow = this.submissionInfo.isInWorkflow();
        Set submissionPagesSet = this.submissionInfo.getProgressBarInfo().keySet();
        String[] submissionPages = submissionPagesSet.toArray(new String[submissionPagesSet.size()]);
        StepAndPage lastStepAndPage = !inWorkflow ? new StepAndPage(submissionPages[submissionPages.length - 2]) : new StepAndPage(submissionPages[submissionPages.length - 1]);
        return lastStepAndPage.equals(this.stepAndPage);
    }

    public StepAndPage getMaxStepAndPageReached() throws SQLException {
        if (this.submission instanceof WorkspaceItem) {
            int page;
            WorkspaceItem workspaceItem = (WorkspaceItem)this.submission;
            int step = workspaceItem.getStageReached();
            if (step < 0) {
                step = 0;
            }
            if ((page = workspaceItem.getPageReached()) < 0) {
                page = 0;
            }
            return new StepAndPage(step, page);
        }
        return new StepAndPage(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public List<String> getErrorFields(Parameters parameters) {
        List<String> fields = new ArrayList<String>();
        String errors = parameters.getParameter("error_fields", "");
        if (errors != null && errors.length() > 0) {
            if (errors.indexOf(44) > 0) {
                fields = Arrays.asList(errors.split(","));
            } else {
                fields.add(errors);
            }
        }
        return fields;
    }

    private String renderJumpButton(StepAndPage givenStepAndPage) {
        try {
            if (givenStepAndPage.equals(this.stepAndPage)) {
                return "current";
            }
            if (givenStepAndPage.compareTo(this.getMaxStepAndPageReached()) > 0) {
                return "disabled";
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void recycle() {
        this.id = null;
        this.submission = null;
        this.stepAndPage = new StepAndPage();
        this.handle = null;
        this.errorFlag = 0;
        this.errorFields = null;
        super.recycle();
    }
}

