/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.aspect.submission.submit.ReviewStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.xml.sax.SAXException;

public class InitialQuestionsStep
extends AbstractSubmissionStep {
    protected static final Message T_head = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.head");
    protected static final Message T_important_note = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.important_note");
    protected static final Message T_and = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.and");
    protected static final Message T_separator = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.separator");
    protected static final Message T_open = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.open_set");
    protected static final Message T_close = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.close_set");
    protected static final Message T_multiple_titles = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.multiple_titles");
    protected static final Message T_multiple_titles_help = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.multiple_titles_help");
    protected static final Message T_multiple_titles_note = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.multiple_titles_note");
    protected static final Message T_published_before = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.published_before");
    protected static final Message T_published_before_help = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.published_before_help");
    protected static final Message T_published_before_note = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.published_before_note");
    protected static final Message T_date_issued = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.date_issued");
    protected static final Message T_citation = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.citation");
    protected static final Message T_publisher = InitialQuestionsStep.message("xmlui.Submission.submit.InitialQuestionsStep.publisher");

    public InitialQuestionsStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Item item = this.submission.getItem();
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        DCValue[] titles = item.getDC("title", "alternative", "*");
        DCValue[] dateIssued = item.getDC("date", "issued", "*");
        DCValue[] citation = item.getDC("identifier", "citation", "*");
        DCValue[] publisher = item.getDC("publisher", null, "*");
        Division div = body.addInteractiveDivision("submit-initial-questions", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        List form = div.addList("submit-initial-questions", "form");
        form.setHead(T_head);
        CheckBox multipleTitles = form.addItem().addCheckBox("multiple_titles");
        multipleTitles.setLabel(T_multiple_titles);
        multipleTitles.setHelp(T_multiple_titles_help);
        multipleTitles.addOption("true");
        if (this.submission.hasMultipleTitles()) {
            multipleTitles.setOptionSelected("true");
        }
        if (titles.length > 0) {
            org.dspace.app.xmlui.wing.element.Item note = form.addItem();
            note.addHighlight("bold").addContent(T_important_note);
            note.addContent(T_multiple_titles_note);
            for (int i = 0; i < titles.length; ++i) {
                if (i > 0) {
                    note.addContent(T_separator);
                }
                note.addContent("\"");
                note.addHighlight("bold").addContent(titles[i].value);
                note.addContent("\"");
            }
        }
        CheckBox publishedBefore = form.addItem().addCheckBox("published_before");
        publishedBefore.setLabel(T_published_before);
        publishedBefore.setHelp(T_published_before_help);
        publishedBefore.addOption("true");
        if (this.submission.isPublishedBefore()) {
            publishedBefore.setOptionSelected("true");
        }
        if (dateIssued.length > 0 || citation.length > 0 || publisher.length > 0) {
            int i;
            org.dspace.app.xmlui.wing.element.Item note = form.addItem();
            note.addHighlight("bold").addContent(T_important_note);
            note.addContent(T_published_before_note);
            if (dateIssued.length > 0) {
                note.addHighlight("bold").addContent(T_date_issued);
                note.addContent(T_open);
                for (i = 0; i < dateIssued.length; ++i) {
                    if (i > 0) {
                        note.addContent(T_separator);
                    }
                    note.addContent(dateIssued[i].value);
                }
                note.addContent(T_close);
            }
            if (dateIssued.length > 0 && (citation.length > 0 || publisher.length > 0)) {
                note.addContent(T_separator);
            }
            if (dateIssued.length > 0 && citation.length > 0 && publisher.length == 0) {
                note.addContent(T_and);
            }
            if (citation.length > 0) {
                note.addHighlight("bold").addContent(T_citation);
                note.addContent(T_open);
                for (i = 0; i < citation.length; ++i) {
                    if (i > 0) {
                        note.addContent(T_separator);
                    }
                    note.addContent(citation[i].value);
                }
                note.addContent(T_close);
            }
            if (citation.length > 0 && publisher.length > 0) {
                note.addContent(T_separator);
            }
            if ((dateIssued.length > 0 || citation.length > 0) && publisher.length > 0) {
                note.addContent(T_and);
            }
            if (publisher.length > 0) {
                note.addHighlight("bold").addContent(T_publisher);
                note.addContent(T_open);
                for (i = 0; i < publisher.length; ++i) {
                    if (i > 0) {
                        note.addContent(T_separator);
                    }
                    note.addContent(publisher[i].value);
                }
                note.addContent(T_close);
            }
        }
        this.addControlButtons(form);
        div.addHidden("prune").setValue("true");
    }

    @Override
    public List addReviewSection(List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        List initSection = reviewList.addList("submit-review-" + this.stepAndPage, "form");
        initSection.setHead(T_head);
        Message multipleTitles = ReviewStep.T_no;
        if (this.submission.hasMultipleTitles()) {
            multipleTitles = ReviewStep.T_yes;
        }
        Message publishedBefore = ReviewStep.T_no;
        if (this.submission.isPublishedBefore()) {
            publishedBefore = ReviewStep.T_yes;
        }
        initSection.addLabel(T_multiple_titles);
        initSection.addItem(multipleTitles);
        initSection.addLabel(T_published_before);
        initSection.addItem(publishedBefore);
        return initSection;
    }
}

