/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.swordclient;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.core.Context;
import org.dspace.sword.client.DSpaceSwordClient;
import org.dspace.sword.client.exceptions.HttpException;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.client.SWORDClientException;

public class SelectTargetAction {
    private static final Message T_url_error = new Message("default", "xmlui.swordclient.SelectTargetAction.url_error");
    private static final Message T_serviceDoc_error = new Message("default", "xmlui.swordclient.SelectTargetAction.serviceDoc_error");
    private static Logger log = Logger.getLogger(SelectTargetAction.class);

    public FlowResult processSelectTarget(Context context, Request request, DSpaceSwordClient DSClient) {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        String url = request.getParameter("url").trim();
        String otherUrl = request.getParameter("otherUrl").trim();
        String username = request.getParameter("username").trim();
        String password = request.getParameter("password").trim();
        String onBehalfOf = request.getParameter("onBehalfOf").trim();
        String chosenUrl = "";
        if (!StringUtils.isEmpty((String)otherUrl)) {
            try {
                new URL(otherUrl);
                chosenUrl = otherUrl;
            }
            catch (MalformedURLException e) {
                result.addError("otherUrl");
            }
        } else if (!StringUtils.isEmpty((String)url)) {
            chosenUrl = url;
        } else {
            result.addError("url");
        }
        if (StringUtils.isEmpty((String)username)) {
            result.addError("username");
        }
        if (StringUtils.isEmpty((String)password)) {
            result.addError("password");
        }
        if (result.getErrors() == null) {
            try {
                DSClient.setRemoteServer(chosenUrl);
                DSClient.setCredentials(username, password, onBehalfOf);
                ServiceDocument serviceDoc = DSClient.getServiceDocument();
                result.setParameter("serviceDoc", serviceDoc);
                result.setContinue(true);
                result.setOutcome(true);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Malformed URL : " + chosenUrl));
                result.setOutcome(false);
                result.setMessage(T_url_error);
            }
            catch (HttpException e) {
                log.error((Object)"HttpException encountered", (Throwable)e);
                result.setOutcome(false);
                result.setMessage(T_serviceDoc_error.parameterize(e.getMessage()));
            }
            catch (SWORDClientException e) {
                log.error((Object)("SwordClientException : " + e.getMessage()), (Throwable)e);
                result.setOutcome(false);
                result.setMessage(T_serviceDoc_error.parameterize(e.getMessage()));
            }
        }
        return result;
    }

    public FlowResult processSelectSubTarget(Context context, Request request, DSpaceSwordClient DSClient) {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        String url = request.getParameter("sub-service").trim();
        log.info((Object)("target selected is : " + url));
        if (StringUtils.isEmpty((String)url)) {
            result.addError("sub-service");
        }
        if (result.getErrors() == null) {
            try {
                DSClient.setRemoteServer(url);
                ServiceDocument serviceDoc = DSClient.getServiceDocument();
                result.setParameter("serviceDoc", serviceDoc);
                result.setOutcome(true);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Malformed URL : " + url));
                result.setOutcome(false);
                result.setMessage(T_url_error);
            }
            catch (HttpException e) {
                log.error((Object)"HttpException encountered", (Throwable)e);
                result.setOutcome(false);
                result.setMessage(T_serviceDoc_error.parameterize(e.getMessage()));
            }
            catch (SWORDClientException e) {
                log.error((Object)("SwordClientException : " + e.getMessage()), (Throwable)e);
                result.setOutcome(false);
                result.setMessage(T_serviceDoc_error.parameterize(e.getMessage()));
            }
        }
        return result;
    }
}

