/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmlworkflow.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.xml.sax.SAXException;

public class WorkflowItemTransformer
extends AbstractDSpaceTransformer {
    private static final Message T_workflow_title = WorkflowItemTransformer.message("xmlui.XMLWorkflow.WorkflowItemTransformer.title");
    private static final Message T_dspace_home = WorkflowItemTransformer.message("xmlui.general.dspace_home");
    private static final Message T_trail = WorkflowItemTransformer.message("xmlui.XMLWorkflow.WorkflowItemTransformer.trail");
    protected static final Message T_showfull = WorkflowItemTransformer.message("xmlui.Submission.general.showfull");
    protected static final Message T_showsimple = WorkflowItemTransformer.message("xmlui.Submission.general.showsimple");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Context context = ContextUtil.obtainContext(this.objectModel);
        XmlWorkflowItem xmlWorkflowItem = this.retrieveWorkflowItem(request, context);
        pageMeta.addMetadata("title").addContent(T_workflow_title.parameterize(xmlWorkflowItem.getItem().getName()));
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        if (!AuthorizeManager.isAdmin((Context)context)) {
            throw new AuthorizeException();
        }
        XmlWorkflowItem xmlWorkflowItem = this.retrieveWorkflowItem(request, context);
        String actionURL = this.contextPath + "/admin/display-workflowItem";
        Division div = body.addInteractiveDivision("perform-task", actionURL, "post", "primary workflow");
        div.addHidden("wfiId").setValue(xmlWorkflowItem.getID());
        String showfull = request.getParameter("submit_full_item_info");
        if (showfull != null && request.getParameter("submit_simple_item_info") != null) {
            showfull = null;
        }
        if (showfull == null) {
            ReferenceSet referenceSet = div.addReferenceSet("narf", "summaryView");
            referenceSet.addReference(xmlWorkflowItem.getItem());
            div.addPara().addButton("submit_full_item_info").setValue(T_showfull);
        } else {
            ReferenceSet referenceSet = div.addReferenceSet("narf", "detailView");
            referenceSet.addReference(xmlWorkflowItem.getItem());
            div.addPara().addButton("submit_simple_item_info").setValue(T_showsimple);
            div.addHidden("submit_full_item_info").setValue("true");
        }
    }

    private XmlWorkflowItem retrieveWorkflowItem(Request request, Context context) throws SQLException, AuthorizeException, IOException {
        int workflowItemId = Util.getIntParameter((HttpServletRequest)request, (String)"wfiId");
        return XmlWorkflowItem.find((Context)context, (int)workflowItemId);
    }
}

