/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.opensearch;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.dspace.app.util.OpenSearch;
import org.dspace.app.xmlui.opensearch.AbstractOpenSearchGenerator;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.FeedUtils;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSQuery;
import org.dspace.search.QueryArgs;
import org.dspace.search.QueryResults;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StandardOpenSearchGenerator
extends AbstractOpenSearchGenerator
implements CacheableProcessingComponent,
Recyclable {
    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            if (this.resultsDoc == null) {
                Context context = ContextUtil.obtainContext(this.objectModel);
                QueryArgs qArgs = new QueryArgs();
                qArgs.setQuery(this.query);
                qArgs.setStart(this.start);
                qArgs.setPageSize(this.rpp);
                if (this.sort != null) {
                    qArgs.setSortOption(this.sort);
                    qArgs.setSortOrder(this.sortOrder);
                }
                QueryResults qResults = null;
                if (this.scope == null) {
                    qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs);
                } else if (this.scope.getType() == 3) {
                    qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Collection)((Collection)this.scope));
                } else if (this.scope.getType() == 4) {
                    qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Community)((Community)this.scope));
                } else {
                    throw new IllegalStateException("Invalid container for search context (container type is " + this.scope.getClass().getName() + ")");
                }
                DSpaceObject[] results = new DSpaceObject[qResults.getHitHandles().size()];
                for (int i = 0; i < qResults.getHitHandles().size(); ++i) {
                    String myHandle = (String)qResults.getHitHandles().get(i);
                    DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)myHandle);
                    if (dso == null) {
                        throw new SQLException("Query \"" + this.query + "\" returned unresolvable handle: " + myHandle);
                    }
                    results[i] = dso;
                }
                this.resultsDoc = OpenSearch.getResultsDoc((String)this.format, (String)this.query, (int)qResults.getHitCount(), (int)qResults.getStart(), (int)qResults.getPageSize(), (DSpaceObject)this.scope, (DSpaceObject[])results, FeedUtils.i18nLabels);
                FeedUtils.unmangleI18N(this.resultsDoc);
            }
            DOMStreamer streamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
            streamer.stream((Node)this.resultsDoc);
        }
        catch (SQLException sqle) {
            throw new SAXException(sqle);
        }
    }
}

