/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.StructuralElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Row
extends AbstractWingElement
implements StructuralElement {
    public static final String E_ROW = "row";
    public static final String A_ROLE = "role";
    private String name;
    private String role;
    private String rend;
    public static final String ROLE_DATA = "data";
    public static final String ROLE_HEADER = "header";
    public static final String[] ROLES = new String[]{"data", "header"};
    List<AbstractWingElement> contents = new ArrayList<AbstractWingElement>();

    protected Row(WingContext context, String name, String role, String rend) throws WingException {
        super(context);
        this.restrict(role, ROLES, "The 'role' parameter must be one of these values: 'data' or 'header'.");
        this.name = name;
        this.role = role;
        this.rend = rend;
    }

    public Cell addCell(String name, String role, int rows, int cols, String rend) throws WingException {
        Cell cell = new Cell(this.context, name, role, rows, cols, rend);
        this.contents.add(cell);
        return cell;
    }

    public Cell addCell(int rows, int cols) throws WingException {
        return this.addCell(null, null, rows, cols, null);
    }

    public Cell addCell(String name, String role, String rend) throws WingException {
        return this.addCell(name, role, 0, 0, rend);
    }

    public Cell addCell(String role) throws WingException {
        return this.addCell(null, role, 0, 0, null);
    }

    public Cell addCell() throws WingException {
        return this.addCell(null, null, 0, 0, null);
    }

    public void addCellContent(String characters) throws WingException {
        Cell cell = this.addCell();
        cell.addContent(characters);
    }

    public void addCellContent(Message message) throws WingException {
        Cell cell = this.addCell();
        cell.addContent(message);
    }

    @Override
    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        AttributeMap attributes = new AttributeMap();
        if (this.name != null) {
            attributes.put("n", this.name);
            attributes.put("id", this.context.generateID(E_ROW, this.name));
        }
        if (this.role != null) {
            attributes.put(A_ROLE, this.role);
        }
        if (this.rend != null) {
            attributes.put("rend", this.rend);
        }
        this.startElement(contentHandler, namespaces, E_ROW, attributes);
        for (AbstractWingElement content : this.contents) {
            content.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        this.endElement(contentHandler, namespaces, E_ROW);
    }

    @Override
    public void dispose() {
        for (AbstractWingElement content : this.contents) {
            content.dispose();
        }
        this.contents.clear();
        this.contents = null;
        super.dispose();
    }
}

