/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.Metadata;
import org.dspace.app.xmlui.wing.element.MetadataElement;
import org.dspace.app.xmlui.wing.element.WingMergeableElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class UserMeta
extends AbstractWingElement
implements WingMergeableElement,
MetadataElement {
    public static final String E_USER_META = "userMeta";
    public static final String A_AUTHENTICATED = "authenticated";
    private boolean merged = false;
    private boolean authenticated = false;
    private List<Metadata> metadatum = new ArrayList<Metadata>();

    protected UserMeta(WingContext context) throws WingException {
        super(context);
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public Metadata addMetadata(String element, String qualifier, String language, boolean allowMultiple) throws WingException {
        Metadata metadata = new Metadata(this.context, element, qualifier, language, allowMultiple);
        this.metadatum.add(metadata);
        return metadata;
    }

    public Metadata addMetadata(String element, String qualifier, String language) throws WingException {
        return this.addMetadata(element, qualifier, null, false);
    }

    public Metadata addMetadata(String element, String qualifier) throws WingException {
        return this.addMetadata(element, qualifier, null, false);
    }

    public Metadata addMetadata(String element) throws WingException {
        return this.addMetadata(element, null, null, false);
    }

    @Override
    public boolean mergeEqual(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (!WingConstants.DRI.URI.equals(namespace)) {
            return false;
        }
        return E_USER_META.equals(localName);
    }

    @Override
    public WingMergeableElement mergeChild(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (WingConstants.DRI.URI.equals(namespace) && "metadata".equals(localName)) {
            String element = attributes.getValue("element");
            String qualifier = attributes.getValue("qualifier");
            String language = attributes.getValue("lang");
            ArrayList<Metadata> remove = new ArrayList<Metadata>();
            for (Metadata metadata : this.metadatum) {
                if (!metadata.equals(element, qualifier, language) || metadata.allowMultiple()) continue;
                remove.add(metadata);
            }
            for (Metadata metadata : remove) {
                metadata.dispose();
                this.metadatum.remove(metadata);
            }
        }
        return null;
    }

    @Override
    public Attributes merge(Attributes attributes) throws SAXException, WingException {
        this.merged = true;
        String mergedAuthenticated = attributes.getValue(A_AUTHENTICATED);
        if (!"yes".equals(mergedAuthenticated)) {
            if ("no".equals(mergedAuthenticated)) {
                if (this.authenticated) {
                    AttributesImpl attributesImpl = new AttributesImpl(attributes);
                    int index = attributesImpl.getIndex(A_AUTHENTICATED);
                    if (index >= 0) {
                        attributesImpl.setValue(index, "yes");
                    } else {
                        attributesImpl.addAttribute("", A_AUTHENTICATED, A_AUTHENTICATED, "CDATA", "yes");
                    }
                    attributes = attributesImpl;
                }
            } else {
                AttributesImpl attributesImpl = new AttributesImpl(attributes);
                attributesImpl.addAttribute("", A_AUTHENTICATED, A_AUTHENTICATED, "CDATA", this.authenticated ? "yes" : "no");
                attributes = attributesImpl;
            }
        }
        return attributes;
    }

    @Override
    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        if (!this.merged) {
            AttributeMap attributes = new AttributeMap();
            if (this.authenticated) {
                attributes.put(A_AUTHENTICATED, "yes");
            } else {
                attributes.put(A_AUTHENTICATED, "no");
            }
            this.startElement(contentHandler, namespaces, E_USER_META, attributes);
        }
        for (Metadata metadata : this.metadatum) {
            metadata.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (!this.merged) {
            this.endElement(contentHandler, namespaces, E_USER_META);
        }
    }

    @Override
    public void dispose() {
        for (AbstractWingElement abstractWingElement : this.metadatum) {
            abstractWingElement.dispose();
        }
        this.metadatum.clear();
        this.metadatum = null;
        super.dispose();
    }
}

