/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword.client;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.handle.HandleManager;
import org.dspace.sword.client.exceptions.HttpException;
import org.dspace.sword.client.exceptions.InvalidHandleException;
import org.dspace.sword.client.exceptions.PackageFormatException;
import org.dspace.sword.client.exceptions.PackagerException;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDEntry;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.client.Client;
import org.purl.sword.client.PostMessage;
import org.purl.sword.client.SWORDClientException;
import org.purl.sword.client.Status;

public class DSpaceSwordClient {
    private Client client = new Client();
    private PostMessage message;
    private String onBehalfOf;
    private String serviceDocUrl;
    private String filename;
    private String tempDirectory;
    private String packageFormat;
    private PackageParameters pkgParams;
    private static Logger log = Logger.getLogger(DSpaceSwordClient.class);

    public DSpaceSwordClient() {
        this.client.setSocketTimeout(200000);
        this.client.setUserAgent("DSpace Sword Client");
        this.message = new PostMessage();
        this.message.setUseMD5(false);
        this.message.setChecksumError(false);
        this.message.setVerbose(false);
        this.message.setNoOp(false);
        this.message.setUserAgent("DSpace Sword Client");
        this.setFilename();
    }

    public void setFilename() {
        if (this.tempDirectory == null || this.tempDirectory.equals("")) {
            this.tempDirectory = System.getProperty("java.io.tmpdir");
        }
        if (!this.tempDirectory.endsWith(System.getProperty("file.separator"))) {
            this.tempDirectory = this.tempDirectory + System.getProperty("file.separator");
        }
        this.filename = this.tempDirectory + UUID.randomUUID().toString();
    }

    public void setRemoteServer(String chosenUrl) throws MalformedURLException {
        this.serviceDocUrl = chosenUrl;
        URL url = new URL(chosenUrl);
        this.client.setServer(url.getHost(), url.getPort());
    }

    public void setCredentials(String username, String password, String onBehalfOf) {
        this.client.setCredentials(username, password);
        this.onBehalfOf = onBehalfOf;
    }

    public ServiceDocument getServiceDocument() throws HttpException, SWORDClientException {
        log.info((Object)("Getting Sword Service Document from " + this.serviceDocUrl));
        ServiceDocument sd = this.client.getServiceDocument(this.serviceDocUrl, this.onBehalfOf);
        Status status = this.client.getStatus();
        if (status.getCode() == 200) {
            log.info((Object)("Sword Service Document successfully retrieved from " + this.serviceDocUrl));
            return sd;
        }
        log.info((Object)("Error retrieving Sword Service Document from " + this.serviceDocUrl));
        throw new HttpException("No service document available - Http status code " + status);
    }

    public void setCollection(String destination) {
        this.message.setDestination(destination);
    }

    public void setFileType(String fileType) {
        this.message.setFiletype(fileType);
    }

    public void setPackageFormat(String packageFormat) throws PackageFormatException {
        if (!packageFormat.equals("http://purl.org/net/sword-types/METSDSpaceSIP")) {
            throw new PackageFormatException("Invalid package format selected");
        }
        this.packageFormat = "METS";
        this.pkgParams = new PackageParameters();
        this.pkgParams.addProperty("dmd", "MODS");
        this.message.setFormatNamespace("http://purl.org/net/sword-types/METSDSpaceSIP");
    }

    public void deposit(Context context, String handle) throws InvalidHandleException, PackagerException, SWORDClientException, PackageFormatException, HttpException {
        File file = new File(this.filename);
        this.createPackage(context, handle, file);
        this.sendMessage();
    }

    public void createPackage(Context context, String handle, File file) throws InvalidHandleException, PackagerException, PackageFormatException {
        PackageDisseminator dip = (PackageDisseminator)PluginManager.getNamedPlugin(PackageDisseminator.class, (String)this.packageFormat);
        if (dip == null) {
            log.error((Object)("Error - unknown package type " + this.packageFormat));
            throw new PackageFormatException("Unknown package type " + this.packageFormat);
        }
        DSpaceObject dso = null;
        try {
            dso = HandleManager.resolveToObject((Context)context, (String)handle);
        }
        catch (SQLException e) {
            log.error((Object)("Unable to resolve handle " + handle));
            throw new InvalidHandleException("Unable to resolve handle " + handle);
        }
        if (dso == null) {
            log.error((Object)("Unable to resolve handle " + handle));
            throw new InvalidHandleException("Unable to resolve handle " + handle);
        }
        try {
            dip.disseminate(context, dso, this.pkgParams, file);
        }
        catch (Exception e) {
            log.error((Object)"Error creating package", (Throwable)e);
            throw new PackagerException("Error creating package", e);
        }
    }

    public String sendMessage() throws SWORDClientException, HttpException {
        this.message.setFilepath(this.filename);
        DepositResponse resp = this.client.postFile(this.message);
        Status status = this.client.getStatus();
        if (status.getCode() == 201 || status.getCode() == 202) {
            SWORDEntry se = resp.getEntry();
            return se.getId();
        }
        String error = status.getCode() + " " + status.getMessage() + " - " + resp.getEntry().getSummary().getContent();
        log.info((Object)("Error depositing Sword package : " + error));
        throw new HttpException(error);
    }
}

