/*
 * Copyright (c) 2003-2006 OFFIS, Henri Tremblay. 
 * This program is made available under the terms of the MIT License.
 */
package org.easymock.classextension.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import sun.reflect.ReflectionFactory;

/**
 * Instantiate a class for Sun JVM.
 * <p>
 * The implementation doesn't call any constructor just like serialization is
 * doing.
 */
public class SunClassInstantiator implements IClassInstantiator {

    public Object newInstance(Class type) throws InstantiationException {
        try {
            Constructor customConstructor = getMungedConstructor(type);
            Object newValue = customConstructor.newInstance(new Object[0]);
            return newValue;
            // ///CLOVER:OFF
        } catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to instantiate "
                    + type.getName() + "'s mock: " + e.getMessage());
        } catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to instantiate "
                    + type.getName() + "'s mock: " + e.getMessage());
        } catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate "
                    + type.getName() + "'s mock: " + e.getMessage());
        }
        // ///CLOVER:ON
    }

    private Constructor getMungedConstructor(Class type)
            throws NoSuchMethodException {
        Constructor javaLangObjectConstructor = Object.class
                .getDeclaredConstructor(new Class[0]);
        Constructor customConstructor = ReflectionFactory
                .getReflectionFactory().newConstructorForSerialization(type,
                        javaLangObjectConstructor);
        return customConstructor;
    }
}
