/*******************************************************************************
 * Copyright (c) 2004, 2008Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.engine.emitter.excel;

public class BookmarkDef
{

	private String name;
	private int startRow, endRow;
	private String sheetName;
	private String generatedName;
	// Represents x coordinate before page is finished, represents column index
	// after page is finished.
	private int startColumn, endColumn = -1;

	public String getValidName( )
	{
		return generatedName == null ? name : generatedName;
	}

	public void setGeneratedName( String generatedName )
	{
		this.generatedName = generatedName;
	}

	public BookmarkDef( String name )
	{
		this.name = name;
	}

	public String getName( )
	{
		return name;
	}

	public void setName( String name )
	{
		this.name = name;
	}

	public int getStartRow( )
	{
		return startRow;
	}

	public void setStartRow( int startRow )
	{
		this.startRow = startRow;
	}

	public int getEndRow( )
	{
		return endRow;
	}

	public void setEndRow( int endRow )
	{
		this.endRow = endRow;
	}

	public void setStartColumn( int startColumn )
	{
		this.startColumn = startColumn;
	}

	public int getStartColumn( )
	{
		return startColumn;
	}

	public int getEndColumn( )
	{
		return endColumn;
	}

	public void setEndColumn( int endColumn )
	{
		this.endColumn = endColumn;
	}

	public String getSheetName( )
	{
		return sheetName;
	}

	public void setSheetName( String sheetName )
	{
		this.sheetName = sheetName;
	}
}
