/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.Arrays;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;

public class EmptyMessage
extends Message {
    public EmptyMessage(CoAP.Type type) {
        super(type);
    }

    public String toString() {
        String appendix = "";
        if (!this.hasEmptyToken() || this.getOptions().asSortedList().size() > 0 || this.getPayloadSize() > 0) {
            String payload = this.getPayloadString();
            if (payload == null) {
                payload = "no payload";
            } else {
                int len = payload.length();
                if (payload.indexOf("\n") != -1) {
                    payload = payload.substring(0, payload.indexOf("\n"));
                }
                if (payload.length() > 24) {
                    payload = payload.substring(0, 20);
                }
                if ((payload = "\"" + payload + "\"").length() != len + 2) {
                    payload = payload + ".. " + payload.length() + " bytes";
                }
            }
            appendix = " NON-EMPTY: Token=" + Arrays.toString(this.getToken()) + ", " + this.getOptions() + ", " + payload;
        }
        return String.format("%s        MID=%5d%s", new Object[]{this.getType(), this.getMID(), appendix});
    }

    public static EmptyMessage newACK(Message message) {
        EmptyMessage ack = new EmptyMessage(CoAP.Type.ACK);
        ack.setDestination(message.getSource());
        ack.setDestinationPort(message.getSourcePort());
        ack.setMID(message.getMID());
        return ack;
    }

    public static EmptyMessage newRST(Message message) {
        EmptyMessage rst = new EmptyMessage(CoAP.Type.RST);
        rst.setDestination(message.getSource());
        rst.setDestinationPort(message.getSourcePort());
        rst.setMID(message.getMID());
        return rst;
    }
}

