/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.observe.ObserveRelation;

public class ObserveLayer
extends AbstractLayer {
    public ObserveLayer(NetworkConfig config) {
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        super.sendRequest(exchange, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(Exchange exchange, Response response) {
        ObserveRelation relation = exchange.getRelation();
        if (relation != null && relation.isEstablished()) {
            if (exchange.getRequest().isAcknowledged() || exchange.getRequest().getType() == CoAP.Type.NON) {
                if (!CoAP.ResponseCode.isSuccess(response.getCode())) {
                    LOGGER.fine("Response has error code " + (Object)((Object)response.getCode()) + " and must be sent as CON");
                    response.setType(CoAP.Type.CON);
                    relation.cancel();
                } else if (relation.check()) {
                    LOGGER.fine("The observe relation check requires the notification to be sent as CON");
                    response.setType(CoAP.Type.CON);
                } else if (response.getType() == null) {
                    response.setType(CoAP.Type.NON);
                }
            }
            response.setLast(false);
            if (response.getType() == CoAP.Type.NON) {
                relation.addNotification(response);
            }
            if (response.getType() == CoAP.Type.CON) {
                this.prepareSelfReplacement(exchange, response);
            }
            Exchange exchange2 = exchange;
            synchronized (exchange2) {
                Response current = relation.getCurrentControlNotification();
                if (current != null && this.isInTransit(current)) {
                    LOGGER.fine("A former notification is still in transit. Postpone " + response);
                    response.setMID(current.getMID());
                    relation.setNextControlNotification(response);
                    return;
                }
                relation.setCurrentControlNotification(response);
                relation.setNextControlNotification(null);
            }
        }
        super.sendResponse(exchange, response);
    }

    private boolean isInTransit(Response response) {
        CoAP.Type type = response.getType();
        boolean acked = response.isAcknowledged();
        boolean timeout = response.isTimedOut();
        boolean result = type == CoAP.Type.CON && !acked && !timeout;
        return result;
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (response.getOptions().hasObserve() && exchange.getRequest().isCanceled()) {
            LOGGER.finer("Rejecting notification for canceled Exchange");
            EmptyMessage rst = EmptyMessage.newRST(response);
            this.sendEmptyMessage(exchange, rst);
        } else {
            super.receiveResponse(exchange, response);
        }
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        ObserveRelation relation;
        if (message.getType() == CoAP.Type.RST && exchange.getOrigin() == Exchange.Origin.REMOTE && (relation = exchange.getRelation()) != null) {
            relation.cancel();
        }
        super.receiveEmptyMessage(exchange, message);
    }

    private void prepareSelfReplacement(Exchange exchange, Response response) {
        response.addMessageObserver(new NotificationController(exchange, response));
    }

    private class NotificationController
    extends MessageObserverAdapter {
        private Exchange exchange;
        private Response response;

        public NotificationController(Exchange exchange, Response response) {
            this.exchange = exchange;
            this.response = response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAcknowledgement() {
            Exchange exchange = this.exchange;
            synchronized (exchange) {
                ObserveRelation relation = this.exchange.getRelation();
                final Response next = relation.getNextControlNotification();
                relation.setCurrentControlNotification(next);
                relation.setNextControlNotification(null);
                if (next != null) {
                    AbstractLayer.LOGGER.fine("Notification has been acknowledged, send the next one");
                    next.setMID(-1);
                    ObserveLayer.this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ObserveLayer.super.sendResponse(NotificationController.this.exchange, next);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRetransmission() {
            Exchange exchange = this.exchange;
            synchronized (exchange) {
                ObserveRelation relation = this.exchange.getRelation();
                final Response next = relation.getNextControlNotification();
                if (next != null) {
                    AbstractLayer.LOGGER.fine("The notification has timed out and there is a fresher notification for the retransmission");
                    this.response.cancel();
                    next.setMID(this.response.getMID());
                    if (next.getType() != CoAP.Type.CON) {
                        next.setType(CoAP.Type.CON);
                        ObserveLayer.this.prepareSelfReplacement(this.exchange, next);
                    }
                    relation.setCurrentControlNotification(next);
                    relation.setNextControlNotification(null);
                    ObserveLayer.this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ObserveLayer.super.sendResponse(NotificationController.this.exchange, next);
                        }
                    });
                }
            }
        }

        @Override
        public void onTimeout() {
            ObserveRelation relation = this.exchange.getRelation();
            AbstractLayer.LOGGER.info("Notification " + relation.getExchange().getRequest().getTokenString() + " timed out. Cancel all relations with source " + relation.getSource());
            relation.cancelAll();
        }
    }
}

