/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.net.InetSocketAddress;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.observe.ObservingEndpoint;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserveRelation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObserveRelation.class);
    private final long checkIntervalTime;
    private final int checkIntervalCount;
    private final ObservingEndpoint endpoint;
    private final Resource resource;
    private final Exchange exchange;
    private Response recentControlNotification;
    private Response nextControlNotification;
    private final String key;
    private volatile boolean established;
    private volatile boolean canceled;
    private long interestCheckTimer = System.currentTimeMillis();
    private int interestCheckCounter = 1;

    public ObserveRelation(ObservingEndpoint endpoint, Resource resource, Exchange exchange) {
        if (endpoint == null) {
            throw new NullPointerException();
        }
        if (resource == null) {
            throw new NullPointerException();
        }
        if (exchange == null) {
            throw new NullPointerException();
        }
        this.endpoint = endpoint;
        this.resource = resource;
        this.exchange = exchange;
        NetworkConfig config = exchange.getEndpoint().getConfig();
        this.checkIntervalTime = config.getLong("NOTIFICATION_CHECK_INTERVAL");
        this.checkIntervalCount = config.getInt("NOTIFICATION_CHECK_INTERVAL_COUNT");
        this.key = StringUtil.toString((InetSocketAddress)this.getSource()) + "#" + exchange.getRequest().getTokenString();
    }

    public boolean isEstablished() {
        return this.established;
    }

    public void setEstablished() {
        if (this.canceled) {
            throw new IllegalStateException(String.format("Could not establish observe relation %s with %s, already canceled (%s)!", this.getKey(), this.resource.getURI(), this.exchange));
        }
        this.established = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        if (!this.canceled) {
            if (!this.established) {
                throw new IllegalStateException(String.format("Observe relation %s with %s not established (%s)!", this.getKey(), this.resource.getURI(), this.exchange));
            }
            LOGGER.debug("Canceling observe relation {} with {} ({})", new Object[]{this.getKey(), this.resource.getURI(), this.exchange});
            this.canceled = true;
            this.established = false;
            Response reponse = this.exchange.getResponse();
            if (reponse != null) {
                reponse.cancel();
            }
            this.resource.removeObserveRelation(this);
            this.endpoint.removeObserveRelation(this);
            this.exchange.executeComplete();
        }
    }

    public void cancelAll() {
        this.endpoint.cancelAll();
    }

    public void notifyObservers() {
        this.resource.handleRequest(this.exchange);
    }

    public Resource getResource() {
        return this.resource;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public InetSocketAddress getSource() {
        return this.endpoint.getAddress();
    }

    public boolean check() {
        boolean check = false;
        check |= this.interestCheckTimer + this.checkIntervalTime < System.currentTimeMillis();
        if (check |= ++this.interestCheckCounter >= this.checkIntervalCount) {
            this.interestCheckTimer = System.currentTimeMillis();
            this.interestCheckCounter = 0;
        }
        return check;
    }

    public Response getCurrentControlNotification() {
        return this.recentControlNotification;
    }

    public void setCurrentControlNotification(Response recentControlNotification) {
        this.recentControlNotification = recentControlNotification;
    }

    public Response getNextControlNotification() {
        return this.nextControlNotification;
    }

    public void setNextControlNotification(Response nextControlNotification) {
        if (this.nextControlNotification != null && nextControlNotification != null) {
            this.nextControlNotification.onComplete();
        }
        this.nextControlNotification = nextControlNotification;
    }

    public String getKey() {
        return this.key;
    }
}

