/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;

public abstract class ConnectorBase
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(ConnectorBase.class.toString());
    private final InetSocketAddress localAddr;
    private Thread receiverThread;
    private Thread senderThread;
    private final BlockingQueue<RawData> outgoing;
    private RawDataChannel receiver;
    private boolean running;

    public ConnectorBase(InetSocketAddress address) {
        if (address == null) {
            throw new NullPointerException();
        }
        this.localAddr = address;
        this.outgoing = new LinkedBlockingQueue<RawData>();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.localAddr;
    }

    public abstract String getName();

    protected abstract RawData receiveNext() throws Exception;

    protected abstract void sendNext(RawData var1) throws Exception;

    protected int getReceiverThreadCount() {
        return 1;
    }

    protected int getSenderThreadCount() {
        return 1;
    }

    private void receiveNextMessageFromNetwork() throws Exception {
        RawData raw = this.receiveNext();
        if (raw != null) {
            this.receiver.receiveData(raw);
        }
    }

    private void sendNextMessageOverNetwork() throws Exception {
        RawData raw = this.outgoing.take();
        if (raw == null) {
            throw new NullPointerException();
        }
        this.sendNext(raw);
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        this.running = true;
        int senderCount = this.getSenderThreadCount();
        int receiverCount = this.getReceiverThreadCount();
        LOGGER.config(this.getName() + "-connector starts " + senderCount + " sender threads and " + receiverCount + " receiver threads");
        this.senderThread = new Worker(this.getName() + "-Sender-" + this.localAddr){

            @Override
            public void work() throws Exception {
                ConnectorBase.this.sendNextMessageOverNetwork();
            }
        };
        this.receiverThread = new Worker(this.getName() + "-Receiver-" + this.localAddr){

            @Override
            public void work() throws Exception {
                ConnectorBase.this.receiveNextMessageFromNetwork();
            }
        };
        this.receiverThread.start();
        this.senderThread.start();
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.senderThread.interrupt();
        this.receiverThread.interrupt();
        this.outgoing.clear();
    }

    @Override
    public synchronized void destroy() {
    }

    @Override
    public void send(RawData msg) {
        if (msg == null) {
            throw new NullPointerException();
        }
        this.outgoing.add(msg);
    }

    @Override
    public void setRawDataReceiver(RawDataChannel receiver) {
        this.receiver = receiver;
    }

    public InetSocketAddress getLocalAddr() {
        return this.localAddr;
    }

    public RawDataChannel getReceiver() {
        return this.receiver;
    }

    public void setReceiver(RawDataChannel receiver) {
        this.receiver = receiver;
    }

    public boolean isRunning() {
        return this.running;
    }

    private abstract class Worker
    extends Thread {
        private Worker(String name) {
            super(name);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                LOGGER.fine("Starting thread " + this.getName());
                while (ConnectorBase.this.running) {
                    try {
                        this.work();
                    }
                    catch (Throwable t) {
                        if (ConnectorBase.this.running) {
                            LOGGER.log(Level.WARNING, "Exception \"" + t + "\" in thread " + this.getName(), t);
                            continue;
                        }
                        LOGGER.fine("Exception \"" + t + "\" stopped thread " + this.getName());
                    }
                }
            }
            finally {
                LOGGER.fine("Thread " + this.getName() + " has terminated");
            }
        }

        protected abstract void work() throws Exception;
    }
}

