/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;

public class RemoteEndpoint {
    private InetAddress Address;
    private int Port;
    private ConcurrentHashMap<Exchange, exchangeInfo> exchangeInfoMap;
    private long[] overallRTO;
    private long[] RTOupdateTimestamp;
    private long currentRTO;
    private long meanOverallRTO;
    private long[] xRTO;
    private long[] xRTT;
    private long[] xRTTVAR;
    public long SRTT;
    public long RTTVAR;
    public long mdev;
    public long mdev_max;
    public double delta;
    public double B_value;
    public static final double F_value = 24.0;
    public static final double B_max_value = 1.0;
    public static final double D_value = 0.9583333333333334;
    public static final int RTT_HISTORY_SIZE = 2;
    public long RTT_max;
    public long[] RTT_sample = new long[2];
    public long RTT_previous;
    public long RTO_min;
    private int currentArrayElement;
    private int nonConfirmableCounter;
    private boolean usesBlindEstimator;
    private boolean isBlindStrong;
    private boolean isBlindWeak;
    private boolean processingNON;
    private static final int RTOARRAYSIZE = 1;
    private static final int STRONGRTOTYPE = 1;
    private static final int WEAKRTOTYPE = 2;
    private static final int NOESTIMATOR = 3;
    private Queue<Exchange> confirmableQueue;
    private Queue<Exchange> nonConfirmableQueue;

    public RemoteEndpoint(int remotePort, InetAddress remoteAddress, NetworkConfig config) {
        int i;
        this.Address = remoteAddress;
        this.Port = remotePort;
        this.overallRTO = new long[1];
        for (i = 0; i < 1; ++i) {
            this.overallRTO[i] = config.getInt("ACK_TIMEOUT");
        }
        this.currentRTO = config.getInt("ACK_TIMEOUT");
        this.xRTO = new long[3];
        this.xRTT = new long[3];
        this.xRTTVAR = new long[3];
        this.RTOupdateTimestamp = new long[3];
        for (i = 0; i <= 2; ++i) {
            this.setEstimatorValues(config.getInt("ACK_TIMEOUT"), 0L, 0L, i);
            this.setRTOtimestamp(System.currentTimeMillis(), i);
        }
        this.meanOverallRTO = config.getInt("ACK_TIMEOUT");
        this.currentArrayElement = 0;
        this.nonConfirmableCounter = 7;
        this.usesBlindEstimator = true;
        this.isBlindStrong = true;
        this.isBlindWeak = true;
        this.processingNON = false;
        this.exchangeInfoMap = new ConcurrentHashMap();
        this.confirmableQueue = new LinkedList<Exchange>();
        this.nonConfirmableQueue = new LinkedList<Exchange>();
    }

    public int getRemotePort() {
        return this.Port;
    }

    public InetAddress getRemoteAddress() {
        return this.Address;
    }

    public void increaseNonConfirmableCounter() {
        ++this.nonConfirmableCounter;
    }

    public int getNonConfirmableCounter() {
        return this.nonConfirmableCounter;
    }

    public void resetNonConfirmableCounter() {
        this.nonConfirmableCounter = 0;
    }

    public long getRTOtimestamp(int rtoType) {
        return this.RTOupdateTimestamp[rtoType];
    }

    public void setRTOtimestamp(long timestamp, int rtoType) {
        this.RTOupdateTimestamp[rtoType] = timestamp;
    }

    public long getxRTO(int rtoType) {
        return this.xRTO[rtoType];
    }

    public long getxRTT(int rttType) {
        return this.xRTT[rttType];
    }

    public long getxRTTVAR(int rttvarType) {
        return this.xRTTVAR[rttvarType];
    }

    public void useBlindEstimator() {
        this.usesBlindEstimator = true;
    }

    public boolean isBlindWeak() {
        return this.isBlindWeak;
    }

    public void setBlindWeak(boolean state) {
        this.isBlindWeak = state;
    }

    public boolean isBlindStrong() {
        return this.isBlindStrong;
    }

    public void setBlindStrong(boolean state) {
        this.isBlindStrong = state;
    }

    public void setEstimatorValues(long rto, long rtt, long rttvar, int estimatorType) {
        this.xRTO[estimatorType] = rto;
        this.xRTT[estimatorType] = rtt;
        this.xRTTVAR[estimatorType] = rttvar;
    }

    public Queue<Exchange> getConfirmableQueue() {
        return this.confirmableQueue;
    }

    public Queue<Exchange> getNonConfirmableQueue() {
        return this.nonConfirmableQueue;
    }

    public Exchange pollConfirmableExchange() {
        return this.confirmableQueue.poll();
    }

    private void calculateMeanOverallRTO() {
        long meanRTO = 0L;
        for (int i = 0; i < 1; ++i) {
            meanRTO += this.overallRTO[i];
        }
        this.meanOverallRTO = meanRTO / 1L;
    }

    public void setCurrentRTO(long currentRTO) {
        this.currentRTO = currentRTO;
    }

    public long getCurrentRTO() {
        return this.currentRTO;
    }

    public void matchCurrentRTO() {
        this.currentRTO = this.meanOverallRTO;
    }

    public void setProcessingNON(boolean value) {
        this.processingNON = value;
    }

    public boolean getProcessingNON() {
        return this.processingNON;
    }

    public long getRTO() {
        long rto = this.usesBlindEstimator && this.isBlindStrong && this.isBlindWeak && this.exchangeInfoMap.size() > 1 ? (long)this.exchangeInfoMap.size() * 2000L : (this.meanOverallRTO != this.currentRTO ? this.currentRTO : this.meanOverallRTO);
        return rto < 32000L ? rto : 32000L;
    }

    public void boostRTOvalue() {
        this.meanOverallRTO *= 2L;
    }

    public void reduceRTOvalue() {
        this.meanOverallRTO = (long)(1000.0 + 0.5 * (double)this.meanOverallRTO);
    }

    public void updateRTO(long newRTO) {
        this.overallRTO[this.currentArrayElement] = newRTO;
        this.currentArrayElement = (this.currentArrayElement + 1) % 1;
        this.calculateMeanOverallRTO();
        this.setCurrentRTO(newRTO);
    }

    public void setEstimatorState(Exchange exchange) {
        if (this.exchangeInfoMap.get(exchange) == null) {
            return;
        }
        if (exchange.getFailedTransmissionCount() == 1 || exchange.getFailedTransmissionCount() == 2) {
            this.exchangeInfoMap.get(exchange).setTypeWeakEstimator();
        } else {
            this.exchangeInfoMap.get(exchange).setTypeNoEstimator();
        }
    }

    public void registerExchange(Exchange exchange, double vbf) {
        exchangeInfo newExchange = new exchangeInfo(System.currentTimeMillis(), vbf);
        this.exchangeInfoMap.put(exchange, newExchange);
    }

    public long getExchangeTimestamp(Exchange exchange) {
        long storedTimestamp = 0L;
        if (this.exchangeInfoMap.isEmpty()) {
            return 0L;
        }
        if (this.exchangeInfoMap.get(exchange) != null) {
            storedTimestamp = this.exchangeInfoMap.get(exchange).getTimestamp();
        }
        return storedTimestamp;
    }

    public double getExchangeVBF(Exchange exchange) {
        double vbf = 2.0;
        if (this.exchangeInfoMap.isEmpty()) {
            return 0.0;
        }
        if (this.exchangeInfoMap.get(exchange) != null) {
            vbf = this.exchangeInfoMap.get(exchange).getVBF();
        }
        return vbf;
    }

    public int getExchangeEstimatorState(Exchange exchange) {
        if (this.exchangeInfoMap.isEmpty()) {
            // empty if block
        }
        if (this.exchangeInfoMap.get(exchange) != null) {
            return this.exchangeInfoMap.get(exchange).getEstimatorType();
        }
        return 0;
    }

    public boolean removeExchangeInfo(Exchange exchange) {
        return this.exchangeInfoMap.remove(exchange) != null;
    }

    public void checkForDeletedExchanges() {
        for (Map.Entry<Exchange, exchangeInfo> o : this.exchangeInfoMap.entrySet()) {
            if (o != null) continue;
            this.exchangeInfoMap.remove(o);
        }
    }

    public int getNumberOfOngoingExchanges(Exchange exchange) {
        return this.exchangeInfoMap.size();
    }

    public void printLinuxStats() {
        System.out.println("SRTT: " + this.SRTT + " RTTVAR: " + this.RTTVAR + " mdev: " + this.mdev + " mdev_max: " + this.mdev_max);
    }

    public void printPeakhopperStats() {
        System.out.println("Delta: " + this.delta + " D: " + 0.9583333333333334 + " B: " + this.B_value + " RTT_max: " + this.RTT_max);
    }

    private class exchangeInfo {
        private long timestamp;
        private double vbf;
        private int estimatorType;

        public exchangeInfo(long timestamp, double vbf) {
            this.timestamp = timestamp;
            this.vbf = vbf;
            this.estimatorType = 1;
        }

        public void setTypeWeakEstimator() {
            this.estimatorType = 2;
        }

        public void setTypeNoEstimator() {
            this.estimatorType = 3;
        }

        public int getEstimatorType() {
            return this.estimatorType;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public double getVBF() {
            return this.vbf;
        }
    }
}

