/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.deduplication;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.deduplication.Deduplicator;

public class CropRotation
implements Deduplicator {
    private static final Logger LOGGER = Logger.getLogger(CropRotation.class.getCanonicalName());
    private ScheduledExecutorService executor;
    private ExchangeMap[] maps;
    private int first;
    private int second;
    private boolean started;
    private long period;
    private Rotation rotation = new Rotation();

    public CropRotation(NetworkConfig config) {
        this.maps = new ExchangeMap[3];
        this.maps[0] = new ExchangeMap();
        this.maps[1] = new ExchangeMap();
        this.maps[2] = new ExchangeMap();
        this.first = 0;
        this.second = 1;
        this.period = config.getInt("CROP_ROTATION_PERIOD");
    }

    @Override
    public synchronized void start() {
        this.started = true;
        this.rotation.schedule();
    }

    @Override
    public synchronized void stop() {
        this.started = false;
        this.rotation.cancel();
        this.clear();
    }

    @Override
    public synchronized void setExecutor(ScheduledExecutorService executor) {
        this.started = false;
        this.rotation.cancel();
        this.executor = executor;
        if (this.started) {
            this.start();
        }
    }

    @Override
    public Exchange findPrevious(Exchange.KeyMID key, Exchange exchange) {
        int f = this.first;
        int s = this.second;
        Exchange prev = this.maps[f].putIfAbsent(key, exchange);
        if (prev != null || f == s) {
            return prev;
        }
        prev = this.maps[s].putIfAbsent(key, exchange);
        return prev;
    }

    @Override
    public Exchange find(Exchange.KeyMID key) {
        int f = this.first;
        int s = this.second;
        Exchange prev = (Exchange)this.maps[f].get(key);
        if (prev != null || f == s) {
            return prev;
        }
        prev = (Exchange)this.maps[s].get(key);
        return prev;
    }

    @Override
    public void clear() {
        this.maps[0].clear();
        this.maps[1].clear();
        this.maps[2].clear();
    }

    private static class ExchangeMap
    extends ConcurrentHashMap<Exchange.KeyMID, Exchange> {
        private static final long serialVersionUID = 1504940670839294042L;

        private ExchangeMap() {
        }
    }

    private class Rotation
    implements Runnable {
        private ScheduledFuture<?> future;

        private Rotation() {
        }

        @Override
        public void run() {
            try {
                this.rotation();
                System.gc();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Exception in Crop-Rotation algorithm", t);
            }
            finally {
                try {
                    this.schedule();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Exception while scheduling Crop-Rotation algorithm", t);
                }
            }
        }

        private void rotation() {
            int third = CropRotation.this.first;
            CropRotation.this.first = CropRotation.this.second;
            CropRotation.this.second = (CropRotation.this.second + 1) % 3;
            CropRotation.this.maps[third].clear();
        }

        private void schedule() {
            LOGGER.fine("CR schedules in " + CropRotation.this.period + " ms");
            this.future = CropRotation.this.executor.schedule(this, CropRotation.this.period, TimeUnit.MILLISECONDS);
        }

        private void cancel() {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
    }
}

