/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction0;
import org.eclipse.collections.api.block.function.primitive.FloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectFloatPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectFloatMap;
import org.eclipse.collections.api.map.primitive.MutableFloatObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectFloatMap;
import org.eclipse.collections.api.map.primitive.ObjectFloatMap;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.ObjectFloatPair;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedFloatCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.factory.primitive.FloatLists;
import org.eclipse.collections.impl.factory.primitive.FloatObjectMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectFloatMaps;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectFloatMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableObjectFloatMap;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ObjectFloatHashMap<K>
implements MutableObjectFloatMap<K>,
Externalizable {
    public static final float EMPTY_VALUE = 0.0f;
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectFloatHashMap.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectFloatHashMap.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private float[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;

    public ObjectFloatHashMap() {
        this.allocateTable(16);
    }

    public ObjectFloatHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity << 1));
        this.allocateTable(capacity);
    }

    public ObjectFloatHashMap(ObjectFloatMap<? extends K> map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectFloatHashMap<K> newMap() {
        return new ObjectFloatHashMap<K>();
    }

    public static <K> ObjectFloatHashMap<K> newWithKeysValues(K key1, float value1) {
        return new ObjectFloatHashMap<K>(1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectFloatHashMap<K> newWithKeysValues(K key1, float value1, K key2, float value2) {
        return new ObjectFloatHashMap<K>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectFloatHashMap<K> newWithKeysValues(K key1, float value1, K key2, float value2, K key3, float value3) {
        return new ObjectFloatHashMap<K>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectFloatHashMap<K> newWithKeysValues(K key1, float value1, K key2, float value2, K key3, float value3, K key4, float value4) {
        return new ObjectFloatHashMap<K>(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectFloatMap)) {
            return false;
        }
        ObjectFloatMap other = (ObjectFloatMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && Float.compare(this.values[i], other.getOrThrow(this.toNonSentinel(this.keys[i]))) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result += (this.toNonSentinel(this.keys[i]) == null ? 0 : this.keys[i].hashCode()) ^ Float.floatToIntBits(this.values[i]);
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectFloatHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectFloatHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(String.valueOf(this.values[i])));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableFloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    public float[] toArray() {
        float[] result = new float[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    public boolean contains(float value) {
        return this.containsValue(value);
    }

    public boolean containsAll(float ... source) {
        for (float item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        return this.containsAll(source.toArray());
    }

    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, 0.0f);
    }

    public void put(K key, float value) {
        int index = this.probe(key);
        if (ObjectFloatHashMap.isNonSentinel(this.keys[index]) && ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(ObjectFloatMap<? extends K> map) {
        map.forEachKeyValue(this::put);
    }

    public void updateValues(ObjectFloatToFloatFunction<? super K> function) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    private void removeKeyAtIndex(K key, int index) {
        if (ObjectFloatHashMap.isNonSentinel(this.keys[index]) && ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = 0.0f;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    public void remove(Object key) {
        this.removeKey(key);
    }

    public float removeKeyIfAbsent(K key, float value) {
        int index = this.probe(key);
        if (ObjectFloatHashMap.isNonSentinel(this.keys[index]) && ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            float oldValue = this.values[index];
            this.values[index] = 0.0f;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    public float getIfAbsentPut(K key, float value) {
        int index = this.probe(key);
        if (ObjectFloatHashMap.isNonSentinel(this.keys[index]) && ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float getIfAbsentPut(K key, FloatFunction0 function) {
        int index = this.probe(key);
        if (ObjectFloatHashMap.isNonSentinel(this.keys[index]) && ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        float value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> float getIfAbsentPutWith(K key, FloatFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectFloatHashMap.isNonSentinel(this.keys[index]) && ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        float value = function.floatValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float getIfAbsentPutWithKey(K key, FloatFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectFloatHashMap.isNonSentinel(this.keys[index]) && ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        float value = function.floatValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float updateValue(K key, float initialValueIfAbsent, FloatToFloatFunction function) {
        int index = this.probe(key);
        if (ObjectFloatHashMap.isNonSentinel(this.keys[index]) && ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        float value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, float value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectFloatHashMap.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public float addToValue(K key, float toBeAdded) {
        int index = this.probe(key);
        if (ObjectFloatHashMap.isNonSentinel(this.keys[index]) && ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    public ObjectFloatHashMap<K> withKeyValue(K key1, float value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectFloatHashMap<K> withKeysValues(K key1, float value1, K key2, float value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectFloatHashMap<K> withKeysValues(K key1, float value1, K key2, float value2, K key3, float value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectFloatHashMap<K> withKeysValues(K key1, float value1, K key2, float value2, K key3, float value3, K key4, float value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ObjectFloatHashMap<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    public ObjectFloatHashMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    public MutableObjectFloatMap<K> asUnmodifiable() {
        return new UnmodifiableObjectFloatMap(this);
    }

    public MutableObjectFloatMap<K> asSynchronized() {
        return new SynchronizedObjectFloatMap(this);
    }

    public ImmutableObjectFloatMap<K> toImmutable() {
        return ObjectFloatMaps.immutable.withAll((ObjectFloatMap)this);
    }

    public float get(Object key) {
        return this.getIfAbsent(key, 0.0f);
    }

    public float getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectFloatHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public float getIfAbsent(Object key, float ifAbsent) {
        int index = this.probe(key);
        if (ObjectFloatHashMap.isNonSentinel(this.keys[index]) && ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectFloatHashMap.isNonSentinel(this.keys[index]) && ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    public boolean containsValue(float value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || Float.compare(this.values[i], value) != 0) continue;
            return true;
        }
        return false;
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void forEachValue(FloatProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    public void forEachKeyValue(ObjectFloatProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    public ObjectFloatHashMap<K> select(ObjectFloatPredicate<? super K> predicate) {
        ObjectFloatHashMap<K> result = ObjectFloatHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public ObjectFloatHashMap<K> reject(ObjectFloatPredicate<? super K> predicate) {
        ObjectFloatHashMap<K> result = ObjectFloatHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public MutableFloatCollection select(FloatPredicate predicate) {
        FloatArrayList result = new FloatArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableFloatCollection reject(FloatPredicate predicate) {
        FloatArrayList result = new FloatArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    public <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        FastList result = FastList.newList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    public int count(FloatPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectFloatToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public RichIterable<FloatIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableFloatIterator iterator = this.floatIterator();
            while (iterator.hasNext()) {
                MutableFloatBag batch = FloatBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch);
            }
        }
        return result;
    }

    public double sum() {
        double result = 0.0;
        double compensation = 0.0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            double adjustedValue = (double)this.values[i] - compensation;
            double nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        return result;
    }

    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float max = 0.0f;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || isMaxSet && Float.compare(max, this.values[i]) >= 0) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float min = 0.0f;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || isMinSet && Float.compare(this.values[i], min) >= 0) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public float maxIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        float max = 0.0f;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || isMaxSet && Float.compare(max, this.values[i]) >= 0) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public float minIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        float min = 0.0f;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i]) || isMinSet && Float.compare(this.values[i], min) >= 0) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        float[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            float first = sortedArray[middleIndex];
            float second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public MutableFloatList toList() {
        FloatArrayList result = new FloatArrayList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableFloatSet toSet() {
        FloatHashSet result = new FloatHashSet(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableFloatBag toBag() {
        FloatHashBag result = new FloatHashBag(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public float[] toSortedArray() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableFloatList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeFloat(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size << 1));
        this.allocateTable(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readFloat());
        }
    }

    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    public RichIterable<ObjectFloatPair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    public MutableFloatObjectMap<K> flipUniqueValues() {
        MutableFloatObjectMap result = FloatObjectMaps.mutable.empty();
        this.forEachKeyValue((ObjectFloatProcedure & Serializable)(key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        float[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectFloatHashMap.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectFloatHashMap.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectFloatHashMap.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (ObjectFloatHashMap.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        int h = element == null ? 0 : element.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.keys.length - 1;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new float[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectFloatHashMap.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity >> 1);
    }

    public Set<K> keySet() {
        return new KeySet();
    }

    public MutableFloatCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ Object[] access$302(ObjectFloatHashMap x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ float[] access$502(ObjectFloatHashMap x0, float[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ObjectFloatPair<K>> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super ObjectFloatPair<K>> procedure) {
            for (int i = 0; i < ObjectFloatHashMap.this.keys.length; ++i) {
                if (!ObjectFloatHashMap.isNonSentinel(ObjectFloatHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectFloatHashMap.this.toNonSentinel(ObjectFloatHashMap.this.keys[i]), ObjectFloatHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectFloatPair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectFloatHashMap.this.keys.length; ++i) {
                if (!ObjectFloatHashMap.isNonSentinel(ObjectFloatHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectFloatHashMap.this.toNonSentinel(ObjectFloatHashMap.this.keys[i]), ObjectFloatHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectFloatPair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectFloatHashMap.this.keys.length; ++i) {
                if (!ObjectFloatHashMap.isNonSentinel(ObjectFloatHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectFloatHashMap.this.toNonSentinel(ObjectFloatHashMap.this.keys[i]), ObjectFloatHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<ObjectFloatPair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ObjectFloatPair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectFloatPair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectFloatHashMap.this.keys;
                while (!ObjectFloatHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectFloatPair<Object> result = PrimitiveTuples.pair(ObjectFloatHashMap.this.toNonSentinel(ObjectFloatHashMap.this.keys[this.position]), ObjectFloatHashMap.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectFloatHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        public void each(Procedure<? super K> procedure) {
            ObjectFloatHashMap.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectFloatProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectFloatHashMap.this.keys.length; ++i) {
                if (!ObjectFloatHashMap.isNonSentinel(ObjectFloatHashMap.this.keys[i])) continue;
                objectFloatProcedure.value(ObjectFloatHashMap.this.toNonSentinel(ObjectFloatHashMap.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectFloatHashMap.this.keys.length; ++i) {
                if (!ObjectFloatHashMap.isNonSentinel(ObjectFloatHashMap.this.keys[i])) continue;
                procedure.value(ObjectFloatHashMap.this.toNonSentinel(ObjectFloatHashMap.this.keys[i]), parameter);
            }
        }

        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        public class InternalKeysViewIterator
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectFloatHashMap.this.keys;
                while (!ObjectFloatHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectFloatHashMap.this.toNonSentinel(ObjectFloatHashMap.this.keys[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectFloatHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    implements MutableFloatCollection {
        private ValuesCollection() {
        }

        public int size() {
            return ObjectFloatHashMap.this.size();
        }

        public boolean isEmpty() {
            return ObjectFloatHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ObjectFloatHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectFloatHashMap.this.keys.length; ++i) {
                    Object key = ObjectFloatHashMap.this.keys[i];
                    if (!ObjectFloatHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectFloatHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean add(float element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(float ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(FloatIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(float item) {
            int oldSize = ObjectFloatHashMap.this.size();
            for (int i = 0; i < ObjectFloatHashMap.this.keys.length; ++i) {
                if (!ObjectFloatHashMap.isNonSentinel(ObjectFloatHashMap.this.keys[i]) || Float.compare(item, ObjectFloatHashMap.this.values[i]) != 0) continue;
                ObjectFloatHashMap.this.removeKey(ObjectFloatHashMap.this.keys[i]);
            }
            return oldSize != ObjectFloatHashMap.this.size();
        }

        public boolean removeAll(FloatIterable source) {
            int oldSize = ObjectFloatHashMap.this.size();
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ObjectFloatHashMap.this.size();
        }

        public boolean removeAll(float ... source) {
            int oldSize = ObjectFloatHashMap.this.size();
            for (float item : source) {
                this.remove(item);
            }
            return oldSize != ObjectFloatHashMap.this.size();
        }

        public boolean retainAll(FloatIterable source) {
            int oldSize = ObjectFloatHashMap.this.size();
            Object sourceSet = source instanceof FloatSet ? (FloatSet)source : source.toSet();
            MutableObjectFloatMap retained = ObjectFloatHashMap.this.select((arg_0, arg_1) -> ValuesCollection.lambda$retainAll$90ee4e2d$1((FloatSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                ObjectFloatHashMap.access$302(ObjectFloatHashMap.this, ((ObjectFloatHashMap)retained).keys);
                ObjectFloatHashMap.access$502(ObjectFloatHashMap.this, ((ObjectFloatHashMap)retained).values);
                ObjectFloatHashMap.this.occupiedWithData = ((ObjectFloatHashMap)retained).occupiedWithData;
                ObjectFloatHashMap.this.occupiedWithSentinels = ((ObjectFloatHashMap)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(float ... source) {
            return this.retainAll(FloatHashSet.newSetWith(source));
        }

        public void clear() {
            ObjectFloatHashMap.this.clear();
        }

        public MutableFloatCollection with(float element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableFloatCollection without(float element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableFloatCollection withAll(FloatIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableFloatCollection withoutAll(FloatIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableFloatCollection asUnmodifiable() {
            return UnmodifiableFloatCollection.of(this);
        }

        public MutableFloatCollection asSynchronized() {
            return SynchronizedFloatCollection.of(this);
        }

        public ImmutableFloatCollection toImmutable() {
            return FloatLists.immutable.withAll((FloatIterable)this);
        }

        public MutableFloatIterator floatIterator() {
            return ObjectFloatHashMap.this.floatIterator();
        }

        public float[] toArray() {
            return ObjectFloatHashMap.this.toArray();
        }

        public boolean contains(float value) {
            return ObjectFloatHashMap.this.containsValue(value);
        }

        public boolean containsAll(float ... source) {
            return ObjectFloatHashMap.this.containsAll(source);
        }

        public boolean containsAll(FloatIterable source) {
            return ObjectFloatHashMap.this.containsAll(source);
        }

        public void forEach(FloatProcedure procedure) {
            this.each(procedure);
        }

        public void each(FloatProcedure procedure) {
            ObjectFloatHashMap.this.forEach(procedure);
        }

        public MutableFloatCollection select(FloatPredicate predicate) {
            return ObjectFloatHashMap.this.select(predicate);
        }

        public MutableFloatCollection reject(FloatPredicate predicate) {
            return ObjectFloatHashMap.this.reject(predicate);
        }

        public <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
            return ObjectFloatHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            return ObjectFloatHashMap.this.injectInto(injectedValue, function);
        }

        public RichIterable<FloatIterable> chunk(int size) {
            return ObjectFloatHashMap.this.chunk(size);
        }

        public float detectIfNone(FloatPredicate predicate, float ifNone) {
            return ObjectFloatHashMap.this.detectIfNone(predicate, ifNone);
        }

        public int count(FloatPredicate predicate) {
            return ObjectFloatHashMap.this.count(predicate);
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            return ObjectFloatHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            return ObjectFloatHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            return ObjectFloatHashMap.this.noneSatisfy(predicate);
        }

        public MutableFloatList toList() {
            return ObjectFloatHashMap.this.toList();
        }

        public MutableFloatSet toSet() {
            return ObjectFloatHashMap.this.toSet();
        }

        public MutableFloatBag toBag() {
            return ObjectFloatHashMap.this.toBag();
        }

        public LazyFloatIterable asLazy() {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }

        public float[] toSortedArray() {
            return ObjectFloatHashMap.this.toSortedArray();
        }

        public MutableFloatList toSortedList() {
            return ObjectFloatHashMap.this.toSortedList();
        }

        public double sum() {
            return ObjectFloatHashMap.this.sum();
        }

        public float max() {
            return ObjectFloatHashMap.this.max();
        }

        public float maxIfEmpty(float defaultValue) {
            return ObjectFloatHashMap.this.maxIfEmpty(defaultValue);
        }

        public float min() {
            return ObjectFloatHashMap.this.min();
        }

        public float minIfEmpty(float defaultValue) {
            return ObjectFloatHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ObjectFloatHashMap.this.average();
        }

        public double median() {
            return ObjectFloatHashMap.this.median();
        }

        public MutableFloatCollection newEmpty() {
            return new FloatHashBag();
        }

        private static /* synthetic */ boolean lambda$retainAll$90ee4e2d$1(FloatSet sourceSet, Object object, float value) {
            return sourceSet.contains(value);
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectFloatHashMap.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectFloatHashMap.this.keys;
            while (!ObjectFloatHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectFloatHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectFloatHashMap.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectFloatHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectFloatHashMap.this.removeKeyAtIndex(ObjectFloatHashMap.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectFloatHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] table = ObjectFloatHashMap.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectFloatHashMap.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectFloatHashMap.this.toNonSentinel(key);
                hashCode += nonSentinelKey == null ? 0 : nonSentinelKey.hashCode();
            }
            return hashCode;
        }

        @Override
        public int size() {
            return ObjectFloatHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectFloatHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectFloatHashMap.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size = ObjectFloatHashMap.this.size();
            Object[] result = new Object[size];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size = ObjectFloatHashMap.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyKeys(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectFloatHashMap.this.size();
            ObjectFloatHashMap.this.removeKey(key);
            return oldSize != ObjectFloatHashMap.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectFloatHashMap.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectFloatHashMap.this.size();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (collection.contains(next)) continue;
                iterator.remove();
            }
            return oldSize != ObjectFloatHashMap.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectFloatHashMap.this.size();
            for (Object object : collection) {
                ObjectFloatHashMap.this.removeKey(object);
            }
            return oldSize != ObjectFloatHashMap.this.size();
        }

        @Override
        public void clear() {
            ObjectFloatHashMap.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count = 0;
            for (int i = 0; i < ObjectFloatHashMap.this.keys.length; ++i) {
                Object key = ObjectFloatHashMap.this.keys[i];
                if (!ObjectFloatHashMap.isNonSentinel(key)) continue;
                result[count++] = ObjectFloatHashMap.this.keys[i];
            }
        }
    }

    private class InternalFloatIterator
    implements MutableFloatIterator {
        private int count;
        private int position;

        private InternalFloatIterator() {
        }

        public boolean hasNext() {
            return this.count != ObjectFloatHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectFloatHashMap.this.keys;
            while (!ObjectFloatHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            float result = ObjectFloatHashMap.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        public void remove() {
            if (this.position == 0 || !ObjectFloatHashMap.isNonSentinel(ObjectFloatHashMap.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectFloatHashMap.this.remove(ObjectFloatHashMap.this.keys[this.position - 1]);
            --this.count;
        }
    }
}

