/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectDoublePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectDoubleProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.ObjectDoublePair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.DoubleBags;
import org.eclipse.collections.impl.factory.primitive.DoubleObjectMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.map.immutable.primitive.AbstractImmutableObjectDoubleMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;

final class ImmutableObjectDoubleHashMap<K>
extends AbstractImmutableObjectDoubleMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectDoubleMap<K> delegate;

    ImmutableObjectDoubleHashMap(ObjectDoubleMap<? extends K> delegate) {
        this.delegate = new ObjectDoubleHashMap<K>(delegate);
    }

    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator((DoubleIterator)this.delegate.doubleIterator());
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(DoublePredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<DoubleIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            DoubleIterator iterator = this.doubleIterator();
            while (iterator.hasNext()) {
                MutableDoubleBag batch = DoubleBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        MutableCollection collection = this.delegate.collect(function);
        return collection.toImmutable();
    }

    public double sum() {
        return this.delegate.sum();
    }

    public double max() {
        return this.delegate.max();
    }

    public double maxIfEmpty(double defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double min() {
        return this.delegate.min();
    }

    public double minIfEmpty(double defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public double[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableDoubleList toSortedList() {
        return this.delegate.toSortedList();
    }

    public double[] toArray() {
        return this.delegate.toArray();
    }

    public double[] toArray(double[] target) {
        return this.delegate.toArray(target);
    }

    public boolean contains(double value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(double ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableDoubleList toList() {
        return this.delegate.toList();
    }

    public MutableDoubleSet toSet() {
        return this.delegate.toSet();
    }

    public MutableDoubleBag toBag() {
        return this.delegate.toBag();
    }

    public LazyDoubleIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableObjectDoubleMap<K> newWithKeyValue(K key, double value) {
        ObjectDoubleHashMap<K> map = ObjectDoubleHashMap.newMap();
        map.putAll((ObjectDoubleMap<K>)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectDoubleMap<K> newWithoutKey(K key) {
        ObjectDoubleHashMap<K> map = ObjectDoubleHashMap.newMap();
        map.putAll((ObjectDoubleMap<K>)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectDoubleMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectDoubleHashMap<K> map = ObjectDoubleHashMap.newMap();
        map.putAll((ObjectDoubleMap<K>)this);
        Iterator<K> iterator = keys.iterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public double get(Object key) {
        return this.delegate.get(key);
    }

    public double getOrThrow(Object key) {
        return this.delegate.getOrThrow(key);
    }

    public double getIfAbsent(Object key, double ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(double value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(DoubleProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectDoubleProcedure<? super K> objectDoubleProcedure) {
        this.delegate.forEachKeyValue(objectDoubleProcedure);
    }

    public ImmutableObjectDoubleMap<K> select(ObjectDoublePredicate<? super K> objectDoublePredicate) {
        return this.delegate.select(objectDoublePredicate).toImmutable();
    }

    public ImmutableObjectDoubleMap<K> reject(ObjectDoublePredicate<? super K> objectDoublePredicate) {
        return this.delegate.reject(objectDoublePredicate).toImmutable();
    }

    public ImmutableObjectDoubleMap<K> toImmutable() {
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet() {
        return UnmodifiableMutableSet.of(this.delegate.keySet());
    }

    public MutableDoubleCollection values() {
        return UnmodifiableDoubleCollection.of(this.delegate.values());
    }

    public LazyIterable<K> keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<ObjectDoublePair<K>> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableDoubleObjectMap<K> flipUniqueValues() {
        MutableDoubleObjectMap result = DoubleObjectMaps.mutable.empty();
        this.forEachKeyValue((ObjectDoubleProcedure & Serializable)(key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result.toImmutable();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectDoubleMap.ImmutableObjectDoubleMapSerializationProxy(this);
    }
}

