/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

@Immutable
public class CollectCharIterable<T>
extends AbstractLazyCharIterable {
    private final LazyIterable<T> iterable;
    private final CharFunction<? super T> function;
    private final CharFunctionToProcedure<T> charFunctionToProcedure;

    public CollectCharIterable(LazyIterable<T> adapted, CharFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.charFunctionToProcedure = new CharFunctionToProcedure(function);
    }

    public CharIterator charIterator() {
        return new CharIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectCharIterable.this.iterable.iterator();
            }

            public char next() {
                return CollectCharIterable.this.function.charValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public void each(CharProcedure procedure) {
        this.iterable.forEachWith(this.charFunctionToProcedure, (Object)procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(CharPredicate predicate) {
        return this.iterable.count((Predicate & Serializable)each -> predicate.accept(this.function.charValueOf(each)));
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return this.iterable.anySatisfy((Predicate & Serializable)each -> predicate.accept(this.function.charValueOf(each)));
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return this.iterable.allSatisfy((Predicate & Serializable)each -> predicate.accept(this.function.charValueOf(each)));
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return this.iterable.allSatisfy((Predicate & Serializable)each -> !predicate.accept(this.function.charValueOf(each)));
    }

    @Override
    public char[] toArray() {
        char[] array = new char[this.size()];
        this.iterable.forEachWithIndex((ObjectIntProcedure & Serializable)(each, index) -> {
            array[index] = this.function.charValueOf(each);
        });
        return array;
    }

    @Override
    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableCharList toList() {
        return CharArrayList.newList((CharIterable)this);
    }

    @Override
    public MutableCharSet toSet() {
        return CharHashSet.newSet((CharIterable)this);
    }

    @Override
    public MutableCharBag toBag() {
        return CharHashBag.newBag((CharIterable)this);
    }

    @Override
    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static final class CharFunctionToProcedure<T>
    implements Procedure2<T, CharProcedure> {
        private static final long serialVersionUID = 1L;
        private final CharFunction<? super T> function;

        private CharFunctionToProcedure(CharFunction<? super T> function) {
            this.function = function;
        }

        public void value(T each, CharProcedure procedure) {
            procedure.value(this.function.charValueOf(each));
        }
    }
}

