/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableByteIntMapFactory;
import org.eclipse.collections.api.map.primitive.ByteIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteIntMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteIntEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteIntHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteIntSingletonMap;

public enum ImmutableByteIntMapFactoryImpl implements ImmutableByteIntMapFactory
{
    INSTANCE;


    public ImmutableByteIntMap empty() {
        return ImmutableByteIntEmptyMap.INSTANCE;
    }

    public ImmutableByteIntMap of() {
        return this.empty();
    }

    public ImmutableByteIntMap with() {
        return this.empty();
    }

    public ImmutableByteIntMap of(byte key, int value) {
        return this.with(key, value);
    }

    public ImmutableByteIntMap with(byte key, int value) {
        return new ImmutableByteIntSingletonMap(key, value);
    }

    public ImmutableByteIntMap ofAll(ByteIntMap map) {
        return this.withAll(map);
    }

    public ImmutableByteIntMap withAll(ByteIntMap map) {
        if (map instanceof ImmutableByteIntMap) {
            return (ImmutableByteIntMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteIntSingletonMap(key, map.get(key));
        }
        return new ImmutableByteIntHashMap(map);
    }
}

