/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;

public interface MutableIntSet
extends MutableIntCollection,
IntSet {
    @Override
    public MutableIntSet select(IntPredicate var1);

    @Override
    public MutableIntSet reject(IntPredicate var1);

    @Override
    default public MutableIntSet tap(IntProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public <V> MutableSet<V> collect(IntToObjectFunction<? extends V> var1);

    @Override
    public MutableIntSet with(int var1);

    @Override
    public MutableIntSet without(int var1);

    @Override
    public MutableIntSet withAll(IntIterable var1);

    @Override
    public MutableIntSet withoutAll(IntIterable var1);

    @Override
    public MutableIntSet asUnmodifiable();

    @Override
    public MutableIntSet asSynchronized();

    public MutableSet<Integer> boxed();

    @Override
    public IntSet freeze();

    @Override
    public ImmutableIntSet toImmutable();

    @Override
    default public MutableIntSet newEmpty() {
        throw new UnsupportedOperationException("Implement in concrete classes.");
    }

    @Override
    default public MutableIntSet union(IntSet set) {
        if (this.size() > set.size()) {
            return this.toSet().withAll(set);
        }
        return set.toSet().withAll(this);
    }

    @Override
    default public MutableIntSet intersect(IntSet set) {
        if (this.size() < set.size()) {
            return this.select(set::contains);
        }
        return set.select(this::contains, this.newEmpty());
    }

    @Override
    default public MutableIntSet difference(IntSet set) {
        return this.reject(set::contains);
    }

    @Override
    default public MutableIntSet symmetricDifference(IntSet set) {
        return set.reject(this::contains, this.difference(set));
    }
}

