/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonException;
import org.eclipse.ditto.json.JsonExceptionBuilder;

@NotThreadSafe
public abstract class AbstractJsonExceptionBuilder<T extends JsonException>
implements JsonExceptionBuilder<T> {
    private final String errorCode;
    private String message;
    private String description;
    private Throwable cause;
    private URI href;

    protected AbstractJsonExceptionBuilder(String errorCode) {
        AbstractJsonExceptionBuilder.checkErrorCode(errorCode);
        this.errorCode = errorCode;
        this.message = null;
        this.description = null;
        this.cause = null;
        this.href = null;
    }

    private static void checkErrorCode(String errorCode) {
        String msgTemplate = "The error code of this exception must not be {0}!";
        Objects.requireNonNull(errorCode, MessageFormat.format("The error code of this exception must not be {0}!", "null"));
        if (errorCode.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("The error code of this exception must not be {0}!", "empty"));
        }
    }

    private static void checkSupplier(Supplier<?> supplier) {
        Objects.requireNonNull(supplier, "The supplier must not be null!");
    }

    @Override
    public JsonExceptionBuilder<T> message(@Nullable String message) {
        this.message = message;
        return this;
    }

    @Override
    public JsonExceptionBuilder<T> message(Supplier<String> messageSupplier) {
        AbstractJsonExceptionBuilder.checkSupplier(messageSupplier);
        return this.message(messageSupplier.get());
    }

    @Override
    public JsonExceptionBuilder<T> description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Override
    public JsonExceptionBuilder<T> description(Supplier<String> descriptionSupplier) {
        AbstractJsonExceptionBuilder.checkSupplier(descriptionSupplier);
        return this.description(descriptionSupplier.get());
    }

    @Override
    public JsonExceptionBuilder<T> cause(@Nullable Throwable cause) {
        this.cause = cause;
        return this;
    }

    @Override
    public JsonExceptionBuilder<T> cause(Supplier<Throwable> causeSupplier) {
        AbstractJsonExceptionBuilder.checkSupplier(causeSupplier);
        return this.cause(causeSupplier.get());
    }

    @Override
    public JsonExceptionBuilder<T> href(@Nullable URI href) {
        this.href = href;
        return this;
    }

    @Override
    public JsonExceptionBuilder<T> href(Supplier<URI> hrefSupplier) {
        AbstractJsonExceptionBuilder.checkSupplier(hrefSupplier);
        return this.href(hrefSupplier.get());
    }

    @Override
    public T build() {
        return this.doBuild(this.errorCode, this.message, this.description, this.cause, this.href);
    }

    protected abstract T doBuild(String var1, String var2, String var3, Throwable var4, URI var5);
}

